<?php
if (!defined("INC_SESSION_INL_H")){
   define("INC_SESSION_INL_H", TRUE);

   include("handler.inl");
   include("proxy.inl");

define('GLOB_KEY_SESSIONS', 'sessions');
$glob[GLOB_KEY_SESSIONS]=array();
define('GLOB_KEY_SESSIONS_ID_GEN', 'sessions_id_gen');
$glob[GLOB_KEY_SESSIONS_ID_GEN]=0;

define('SESSION_PROC_KPO', 0x01);
define('SESSION_PROC_CAM', 0x02);
define('SESSION_PROC_PASS', 0x03);
define('SESSION_PROC_INP', 0x04);

function &session_get_lp(&$slink) {
  global $glob;
  $fret=false;
  if (!($sobj=&session_obj_get($slink))) return $fret;
  if (!is_array(@$sobj['lp'])) return $fret;
  return $sobj['lp'];

  if (!($cobj=&conn_obj_get($sobj['key']))) return $fret;
  if (!is_array(@$cobj['lp'])) return $fret;
  return $cobj['lp'];
}

function session_lp_update(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!($lp=&session_get_lp($sobj))) return false;
  
  $lp['data']=$sobj['data'];
  if (is_string(@$lp['data']['barcode']['data'])) $lp['buid']=$lp['data']['barcode']['data'];
  if (is_string(@$lp['data']['faceid']['data'])) $lp['fuid']=$lp['data']['faceid']['data'];
  return true;
}

function session_uid2cid($uid) {
  global $glob;
  if (is_array(@$glob['cam_uids']) && array_key_exists($uid, $glob['cam_uids'])) return @$glob['cam_uids'][$uid];
  return false;
}

function session_send_lock_signal(&$slink) {
  global $dmn_main_conn;
  if (!($sobj=&session_obj_get($slink))) return false;
  $pool=$dmn_main_conn['pool'];
  
  $pool->send($sobj['key'], eproto_packet(eproto_cmd_Signal, EPROTO_PK_FLAGS_RT_USART, numcoder_encode(POCKET_SIGNAL_LOCKED, 1).
                                                                                       numcoder_encode(0x00, 1). // flags
                                                                                       numcoder_encode(1500, 4) // timeout
                                                                                       ));
  $pool->send($sobj['key'], eproto_packet(eproto_cmd_Enquire));
  $sobj['gp_lock_sent']=get_mtf();
  return true;  
}

function session_send_unlock_signal(&$slink) {
  global $dmn_main_conn;
  if (!($sobj=&session_obj_get($slink))) return false;
  $pool=$dmn_main_conn['pool'];  
  $pool->send($sobj['key'], eproto_packet(eproto_cmd_Signal, EPROTO_PK_FLAGS_RT_USART, numcoder_encode(POCKET_SIGNAL_UNLOCKED, 1).
                                                                                       numcoder_encode(0x00, 1). // flags
                                                                                       numcoder_encode(0x00000000, 4) // timeout
                                                                                       ));
  $pool->send($sobj['key'], eproto_packet(eproto_cmd_Interactive, EPROTO_PK_FLAGS_RT_USART, pocket_interactive('', 0, 0, false)));
  $sobj['gp_lock_sent']=get_mtf();
  return true;  
}

function session_gp_lock(&$slink, $lval=true) {
  if (!($sobj=&session_obj_get($slink))) return false;
  $sobj['gp_locked']=$lval;
  return session_send_lock_signal($sobj);
}

function session_gp_unlock(&$slink) {
  global $dmn_main_conn;
  if (!($sobj=&session_obj_get($slink))) return false;
  if ($sobj['gp_locked']) {
    $sobj['gp_locked']=false;
    if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return true;
    $gpkey=cgate_get_op_conn($conn);
    if ($gpkey) {
      $pool=$dmn_main_conn['pool'];  
      $pool->send($gpkey, eproto_packet(eproto_cmd_Interactive, EPROTO_PK_FLAGS_RT_MAIN, pocket_interactive('', 0, 0, true)));
      $pool->send($gpkey, eproto_packet(eproto_cmd_Interactive, EPROTO_PK_FLAGS_RT_MAIN, pocket_interactive('', 0, 0, false)));
      $sobj['gp_lock_sent']=get_mtf();
    } else return session_send_unlock_signal($sobj);
  }
  return true;
}

function session_is_alive(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (@$sobj['processed'] || @$sobj['completed'] || @$sobj['stage']=='done') return false;
  return true;
}

function session_interactive_dev_lkeys(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  $ret=array();
  if (is_array(@$sobj['dev_locked']) && count($sobj['dev_locked'])>0) {
    foreach (array_keys($sobj['dev_locked']) as $lkey) {
      if ($sobj['dev_locked'][$lkey]) $ret[]=$lkey;
    }
  }
  return (count($ret)>0)?$ret:false;
}

function session_send_dev_lock(&$slink, $lkeys=false) {
  global $dmn_main_conn;
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array($lkeys)) {
    $lkeys=(is_string($lkeys))?array($lkeys):array();
  }
  foreach($lkeys as $lkey) {
    $text=@$sobj['dev_locked'][$lkey];
    $pload=pocket_interactive_waiting(1500, true, false);
    if (is_string($text) && strlen($text)>0) $pload=pocket_interactive_text($text).pocket_interactive_waiting(1500, false, false);
    $dmn_main_conn['pool']->send($lkey, eproto_packet(eproto_cmd_Interactive, EPROTO_PK_FLAGS_RT_MAIN, $pload));
  }
//  $sobj['dev_lock_sent']=get_mtf();
  return true;  
}

function session_send_dev_unlock(&$slink, $lkey) {
  global $dmn_main_conn;
  if (!($sobj=&session_obj_get($slink))) return false;
  $dmn_main_conn['pool']->send($lkey, eproto_packet(eproto_cmd_Interactive, EPROTO_PK_FLAGS_RT_MAIN, pocket_interactive_waiting(0, false, false)));
//  $sobj['dev_lock_sent']=get_mtf();
  return true;  
}

function session_dev_lock(&$slink, $lkey=false, $interactive=true) {
  global $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
//  logp($glob['log_file'], "session_dev_lock 0:\n".var_d(array($sobj, $lkey), true)."\n", true);
  if (!is_string($lkey)) $lkey=(string)$sobj['key'];
  if (!is_array(@$sobj['dev_locked'])) $sobj['dev_locked']=array();
  $sobj['dev_locked'][$lkey]=$interactive;
  if ($conn=&conn_get_settings($lkey, 'MAIN', true)) {
    $conn['reader_locked']=$sobj['s_id'];
  }
//  logp($glob['log_file'], "session_dev_lock 1:\n".var_d(array($sobj, $lkey), true)."\n", true);
  return session_send_dev_lock($sobj, $lkey);
}

function _session_dev_unlock(&$slink, $lkey) {
  global $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
//  logp($glob['log_file'], "_session_dev_unlock 0:\n".var_d(array($sobj, $lkey), true)."\n", true);
  if (is_array(@$sobj['dev_locked']) && array_key_exists($lkey, $sobj['dev_locked'])) {
    if ($conn=&conn_get_settings($lkey, 'MAIN', true)) {
      $conn['reader_locked']=false;
    }
    session_send_dev_unlock($sobj, $lkey);
    unset($sobj['dev_locked'][$lkey]);
  }
//  logp($glob['log_file'], "_session_dev_unlock 1:\n".var_d(array($sobj, $lkey), true)."\n", true);
  return true;
}

function session_dev_unlock(&$slink, $lkey=false) {
  global $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
//  logp($glob['log_file'], "session_dev_unlock 0:\n".var_d(array($sobj, $lkey), true)."\n", true);
  if (is_array(@$sobj['dev_locked']) && count($sobj['dev_locked'])>0) {
    $dev_list=(is_string($lkey) && array_key_exists($lkey, $sobj['dev_locked']))?array($lkey):array_keys($sobj['dev_locked']);
    foreach($dev_list as $dev_key) {
      _session_dev_unlock($sobj, $dev_key);
    }
    if (!is_array(@$sobj['dev_locked']) || count($sobj['dev_locked'])==0) $sobj['dev_locked']=false;
  }
//  logp($glob['log_file'], "session_dev_unlock 1:\n".var_d(array($sobj, $lkey), true)."\n", true);
  return true;
}

function session_set_result(&$slink, $result=false, $msg=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  if (is_null($result)) {
    if (@array_key_exists('result', @$sobj['data'])) unset($sobj['data']['result']);
  } else if ($result===false) {
  } else {
    $sobj['data']['result']=$result;
  }
  if (!is_null($msg)) $sobj['data']['message']=$msg;
  $sobj['data']['result_time']=get_mtf();
  return true;
}

function session_set_rfid_data(&$slink, $rfid_data, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  $sobj['data']['rfid']=$rfid_data;
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['rfid'][$key]=$val;
  return true;
}

function session_set_barcode_data(&$slink, $barcode_data, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  $sobj['data']['barcode']=$barcode_data;
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['barcode'][$key]=$val;
  return true;
}

function session_set_faceid_data(&$slink, $faceid_data, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  $sobj['data']['faceid']=$faceid_data;
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['faceid'][$key]=$val;
  return true;
}

function session_set_passed_data(&$slink, $pass_data, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (is_null($pass_data)) {
    if (@array_key_exists('passed', @$sobj)) unset($sobj['passed']);
  } else if ($pass_data===false) {
  } else {
    $sobj['passed']=$pass_data;
  }
  if (is_array($params) && is_array(@$sobj['passed'])) foreach($params as $key=>$val) $sobj['passed'][$key]=$val;
  return true;
}

function session_set_kpo_result(&$slink, $result, $msg=NULL, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  if (!is_array(@$sobj['data']['kpo'])) $sobj['data']['kpo']=array();
  if (is_null($result)) {
    if (@array_key_exists('result', @$sobj['data']['kpo'])) unset($sobj['data']['kpo']['result']);
  } else if ($result===false) {
  } else {
    $sobj['data']['kpo']['result']=$result;
  }
  if (!is_null($msg)) $sobj['data']['kpo']['message']=$msg;
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['kpo'][$key]=$val;
  $sobj['data']['kpo']['end_time']=get_mtf();
  return true;
}

function session_set_kpo_rkey(&$slink, $rkey, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  if (!is_array(@$sobj['data']['kpo'])) $sobj['data']['kpo']=array();
  if (is_null($rkey)) {
    if (@array_key_exists('rkey', @$sobj['data']['kpo'])) unset($sobj['data']['kpo']['rkey']);
  } else if ($rkey===false) {
  } else {
    $sobj['data']['kpo']['rkey']=$rkey;
  }
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['kpo'][$key]=$val;
  return true;
}

function session_set_cam_result(&$slink, $result, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  if (!is_array(@$sobj['data']['cam'])) $sobj['data']['cam']=array();
  if (is_null($result)) {
    if (@array_key_exists('result', @$sobj['data']['cam'])) unset($sobj['data']['cam']['result']);
  } else if ($result===false) {
  } else {
    $sobj['data']['cam']['result']=$result;
  }
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['cam'][$key]=$val;
  $sobj['data']['cam']['end_time']=get_mtf();
  return true;
}

function session_set_cam_rkey(&$slink, $rkey, $params=NULL) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) $sobj['data']=array();
  if (!is_array(@$sobj['data']['cam'])) $sobj['data']['cam']=array();
  if (is_null($rkey)) {
    if (@array_key_exists('rkey', @$sobj['data']['cam'])) unset($sobj['data']['cam']['rkey']);
  } else if ($rkey===false) {
  } else {
    $sobj['data']['cam']['rkey']=$rkey;
  }
  if (is_array($params)) foreach($params as $key=>$val) $sobj['data']['cam'][$key]=$val;
  return true;
}

function session_clear_cam_data(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!is_array(@$sobj['data'])) return false;
  if (!array_key_exists('cam', $sobj['data'])) return false;
  unset($sobj['data']['cam']);
  return true;
}

function session_fix_allow_message($msg) {
  global $glob;
  if ($msg=='') $msg=$glob['service_fixed_msg'];
  return $msg;
}

function session_fix_denied_message($msg) {
  global $glob;
  if ($msg=='') $msg=$glob['service_denied_msg'];
  return $msg;
}

function session_fix_error_message($msg) {
  global $glob;
  if ($msg=='') $msg=$glob['service_err_msg'];
  return $msg;
}

function session_fix_link_error_message($msg) {
  global $glob;
  if ($msg=='') $msg=$glob['service_link_err_msg'];
  return $msg;
}

function session_passed2val($parr) {
  if (!is_array($parr)) return false;
  if (!@$parr['passed']) return false;
  if (is_float(@$parr['time'])) return $parr['time'];
  return true;
}

function session_pass_time(&$slink) {
  global $dmn_main_conn, $glob;
  $tmo=(float)@$glob['term_pass_expire_time'];
  if ($tmo<=0) $tmo=8.0;
  return $tmo;
}


function session_cam_max_time_ms() {
  global $glob;
  $mt=round(((float)@$glob['cam_service_expire_time'])*1000);
  if ($mt<2000) $mt=2000;
  return (int)$mt;
}

function session_cam_start_process(&$pool, $key, $tid, $uid, $cid, $params=NULL) {
  global $dmn_main_conn, $glob;
  if (!array_key_exists($tid, $glob['cam_links'])) return false;
  $skey=@$params;
  if (!($sobj=&session_obj_get($skey))) return false;
  $rkey=false;
  if (strlen($cid)>0) {
    session_set_cam_result($sobj, CAM_RES_FAIL, array('uid'=>$uid, 'cid'=>$cid, 'tid'=>$tid));
    $sobj['cam_config']=$glob['cam_links'][$tid];
    $ccfg=$sobj['cam_config'];
    $cam_url=$glob['cam_service_ident_path'].'?cameraPid='.$ccfg['pid'].'&personKey='.$cid;
    $camfunc='httpr_new';
    plogs('cam request proto ['.@$glob['cam_service_proto'].']\n');
    if (@$glob['cam_service_proto']=='helios') {
      $camfunc='helios_new';
      $cam_url=array(
        'cam_pid'=>$ccfg['pid'],
        'person_id'=>$cid,
      );
    } else if (@$glob['cam_service_proto']=='recx') {
      $cam_url=$glob['cam_service_ident_path'];
    } else if (@$glob['cam_service_proto']=='crt') {
      
    }
    if (!($rkey=$camfunc($pool, $sobj['key'], REQ_TAG_CAM, dmnh_hcfg_cam(), $cam_url, $skey))) {
      plogs("cam request fail. link down.\n");
    } else {
      session_set_cam_rkey($sobj, $rkey, array('start_time'=>get_mtf()));
      $pk=eproto_packet(eproto_cmd_Interactive);
      $pk['flags']=session_get_reader_type($sobj);
      $pk['payload']=pocket_interactive(from_utf8("Посмотрите\nв камеру"), session_cam_max_time_ms()+500, 0, false);
      $pool->send($sobj['key'], $pk);
      session_set_cam_result($sobj, CAM_RES_UNDEF);
    }
  }
  return $rkey;
}

function _session_get_raw_uid(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (is_string(@$sobj['uid_raw']) && strlen(@$sobj['uid_raw'])>3) return $sobj['uid_raw'];
  if (!is_string(@$sobj['uid']) || strlen(@$sobj['uid'])<2) return false;
  $ret=hexutil_hex2buf($sobj['uid']);
  if (!is_string($ret) || strlen($ret)<4) return false;
  return $ret;
}
function session_get_raw_uid(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (is_string(@$sobj['uid_raw']) && strlen(@$sobj['uid_raw'])>3) return $sobj['uid_raw'];
  if (is_string(@$sobj['uid']) && strlen(@$sobj['uid'])>1) return @hexutil_hex2buf($sobj['uid']);
  if (is_string(@$sobj['data']['rfid']['uid_raw']) && strlen(@$sobj['data']['rfid']['uid_raw'])>3) return $sobj['data']['rfid']['uid_raw'];
  if (is_string(@$sobj['data']['rfid']['uid']) && strlen(@$sobj['data']['rfid']['uid'])>1) return @hexutil_hex2buf($sobj['data']['rfid']['uid']);
  $ret=@hexutil_hex2buf(@str_pad(@$sobj['data']['barcode']['data'], 14, '0', STR_PAD_LEFT));
  if (!$ret) $ret=@$sobj['data']['barcode']['data'];
  if (!$ret) $ret=@$sobj['data']['faceid']['data'];
  return $ret;
}

function session_get_rce_uid(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (array_key_exists('rce_uid', $sobj)) return $sobj['rce_uid'];
  return session_get_raw_uid($sobj);
}

function session_get_reader_type(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return 0;
  $ret=(int)@$sobj['data']['rfid']['reader_type'];
  if (!$ret) $ret=(int)@$sobj['data']['barcode']['reader_type'];
  if (!$ret) $ret=(int)@$sobj['data']['faceid']['reader_type'];
  return $ret;
}

function session_get_src_pk_code(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return 0;
  $ret=(int)@$sobj['data']['rfid']['src_pk_code'];
  if (!$ret) $ret=(int)@$sobj['data']['barcode']['src_pk_code'];
  if (!$ret) $ret=(int)@$sobj['data']['faceid']['src_pk_code'];
  return $ret;
}

function session_get_src_pk_flags(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return 0;
  $ret=(int)@$sobj['data']['rfid']['src_pk_flags'];
  if (!$ret) $ret=(int)@$sobj['data']['barcode']['src_pk_flags'];
  if (!$ret) $ret=(int)@$sobj['data']['faceid']['src_pk_flags'];
  return $ret;
}

function session_kpo_send_request(&$slink) {
  global $dmn_main_conn, $glob;
  
  if (!($sobj=&session_obj_get($slink))) return false;
  
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  $gpkey=cgate_get_op_conn($conn);

  $lp=&session_get_lp($sobj);

  $pool=$dmn_main_conn['pool'];
  $sobj['req_time']=get_mtf();
  session_set_kpo_result($sobj, KPO_RES_UNDEF);
  session_set_kpo_rkey($sobj, NULL, array('start_time'=>get_mtf(), 'expire_time'=>get_mtf()+(float)$glob['kpo_request_expire_time']));
  $lrp=false;

  if (proxy_set_session_key_by_conkey($dmn_main_conn['pool'], $sobj['key'], $sobj['id'])) {
    $pkey=proxy_get_child_key($dmn_main_conn['pool'], $sobj['key']);
//	$uid=@hexutil_hex2buf(session_get_raw_uid($sobj));
    if ($pkey) $dmn_main_conn['pool']->send($pkey, proxy_rtag_pk(session_get_raw_uid($sobj), session_get_src_pk_code($sobj), session_get_src_pk_flags($sobj)));
    return true;
  }
  
  if ($glob['ucs_child_key']!==false) {
    $dir=(@$conn['role']=='checkout')?'O':'I';
    ucs_send_request($pool, $sobj['uid'], @$conn['id'], $dir);
    return true;
  }
  
  if (@$glob['txp_subscriber_key']!==false) {
    txp_send($glob['txp_subscriber_key'], 'SESSION_START', @$conn['id'], $sobj['uid']);
    return true;
  }

  if (@jsp_data('jsp_subscriber_key')!==false) {
    $data=array();
//    $data['tid']=@$conn['id'];
    $data['uid']=@$sobj['uid'];
//    $data['sid']=@$sobj['s_id'];
    $data['lockers_data']=fmt_llist_craft(@$sobj['data']['rfid']['lockers_data']);
    $data['auth']=@$sobj['data']['rfid']['auth'];
    
//    $rid=jsp_send_request(jsp_data('jsp_subscriber_key'), 'pass_request', $data, false, array('s_id'=>$sobj['s_id']));
    $rid=jsp_send_request(jsp_data('jsp_subscriber_key'), 'tag_read', $data);//, false, array('s_id'=>$sobj['s_id']));
    if (is_null($rid)) {
      $lrp=true;
    } else if ($rid!==false) {
      session_set_kpo_rkey($sobj, $rid);
      return true;
    } else return true;
  }
  
  if ($lrp || @$glob['local_request_processing']) {
    if (@$glob['crt_auto_fix_message'] && is_array(@$sobj['data']['faceid']['crt'])) {
      $fdata=$sobj['data']['faceid']['crt'];
      $msg=trim(@$fdata['pdata']['fio']).', '.trim(@$fdata['score_prc_str']);
      if (strlen($msg)<3) $msg=$glob['service_fixed_msg'];
      session_set_kpo_result($sobj, KPO_RES_YES, $msg, array('kpo_answer_data'=>'autofix'));
      $sobj['ap_mode']=true;
    } else if (@$glob['service_autofix_expired']) {
      session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg'], array('kpo_answer_data'=>'autofix'));
      $sobj['ap_mode']=true;
    } else {
      session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
    }
    return true;
  }
  
  if ($glob['http_service_active'] ) {
    if (handler_exec('hcfg_http', false, $http_cfg)) {
      if (handler_exec('hurl_http', array(REQ_TAG_QRY, &$sobj, &$conn, &$http_cfg), $hurl)) {
        if (!($rkey=httpr_new($pool, $sobj['key'], REQ_TAG_QRY, $http_cfg, $hurl, $sobj['id']))) {
          plogs("http request fail. link down.\n");
        } else {
          session_set_kpo_rkey($sobj, $rkey);
          return true;
        }
      }
    }
  }
  
  if (@$glob['service_autofix_expired']) {
    session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg'], array('kpo_answer_data'=>'autofix'));
    $sobj['ap_mode']=true;
  } else {
    session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
  }
  return true;
}

function session_kpo_send_report(&$slink) {
  global $dmn_main_conn, $glob;
  
  if (!($sobj=&session_obj_get($slink))) return false;
  $passed=session_passed2val(@$sobj['passed']);
  
  if (@$sobj['no_report']) return true;
  
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  $gpkey=cgate_get_op_conn($conn);
  if ($conn['reg_query']) return true;
  $nprb=!@$glob['send_not_passed_resp'] && !$passed;
//  if (!@$glob['send_not_passed_resp'] && !$passed) return true;
  if (@$glob['send_not_passed_as_passed'] && !$passed) $passed=true;
  
  
  $lp=&session_get_lp($sobj);

  $pool=$dmn_main_conn['pool'];
  $sobj['rep_time']=get_mtf();
//  session_set_kpo_result($sobj, KPO_RES_UNDEF);
//  session_set_kpo_rkey($sobj, NULL, array('start_time'=>get_mtf(), 'expire_time'=>get_mtf()+(float)$glob['kpo_request_expire_time']));

  if (proxy_set_session_key_by_conkey($dmn_main_conn['pool'], $sobj['key'], $sobj['id'])) {
    $pkey=proxy_get_child_key($dmn_main_conn['pool'], $sobj['key']);
    if ($pkey) $dmn_main_conn['pool']->send($pkey, proxy_rcer_pk(session_get_rce_uid($sobj), ($passed)?1:0, session_get_src_pk_flags($sobj)));
    return true;
  }
  
  if ($glob['ucs_child_key']!==false) {
    if ($nprb) return true;
    $dir=(@$conn['role']=='checkout')?'O':'I';
    if (!$passed) $dir=UCS_CANCEL_SYMBOL;
    ucs_send_transaction($pool, $sobj['uid'], @$conn['id'], $dir);
    return true;
  }
  
  if (@$glob['txp_subscriber_key']!==false) {
    if ($nprb) return true;
    txp_send($glob['txp_subscriber_key'], 'SESSION_END', @$conn['id'], $sobj['uid'], ($passed)?'Y':'N');
    return true;
  }
  
  if (@jsp_data('jsp_subscriber_key')!==false) {
    $data=array();
//    $data['tid']=@$conn['id'];
    $data['uid']=@$sobj['uid'];
//    $data['sid']=@$sobj['s_id'];
    $data['passed']=$passed;
    
    if (is_string(@$sobj['jsp_rid'])) {
      jsp_answer_request(jsp_data('jsp_subscriber_key'), $sobj['jsp_rid'], $data);
    } else if (!$nprb) {
      jsp_send_request(jsp_data('jsp_subscriber_key'), 'pass_report', $data);
    }
    return true;
  }
  
  if (@$glob['local_request_processing']) return true;

  if ($glob['http_service_active'] ) {
    if ($nprb) return true;
    if (handler_exec('hcfg_http', false, $http_cfg)) {
      if (handler_exec('hurl_http', array(REQ_TAG_REG, &$sobj, &$conn, &$http_cfg, $passed), $hurl)) {
        if (!($rkey=httpr_new($pool, $sobj['key'], REQ_TAG_REG, $http_cfg, $hurl, $sobj['id']))) {
          plogs("http request fail. link down.\n");
//        } else {
//          session_set_kpo_rkey($sobj, $rkey);
//          return true;
        }
      }
    }
  }
  return true;
}

function session_cam_send_request(&$slink) {
  global $dmn_main_conn, $glob;
    
  if (!($sobj=&session_obj_get($slink))) return false;
  session_clear_cam_data($slink);
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  $gpkey=cgate_get_op_conn($conn);
  if (!@$glob['cam_service_active']) return true;
  if (!@$sobj['cid'] || strlen(trim($sobj['cid']))==0) return true;
  if (@$glob['cam_service_use_uid']) $sobj['cid']=$sobj['uid'];

  $ccfg=@$glob['cam_links'][$conn['con_key']];
  if (!is_array($ccfg)) return true;
  
  $lp=&session_get_lp($sobj);

  $pool=$dmn_main_conn['pool'];

  session_set_cam_result($sobj, CAM_RES_UNDEF);
  session_set_cam_rkey($sobj, NULL, array('start_time'=>get_mtf(), 'uid'=>$sobj['uid'], 'cid'=>$sobj['cid'], 'tid'=>$conn['con_key']));
  
  $sobj['cam_config']=$ccfg;
  $cam_url=$glob['cam_service_ident_path'].'?cameraPid='.$ccfg['pid'].'&personKey='.$sobj['cid'];
  $cfg_cam_params=array(
      'cam_pid'=>$ccfg['pid'],
      'person_id'=>$sobj['cid'],
  );
  
  $rkey=false;
  $camfunc='httpr_new';
  if (@$glob['cam_service_proto']=='helios') {
    $camfunc='helios_new';
    $cam_url=array(
      'cam_pid'=>$ccfg['pid'],
      'person_id'=>$sobj['cid'],
    );
  } else if (@$glob['cam_service_proto']=='recx') {
    $cam_url=$glob['cam_service_ident_path'];
  } else if (@$glob['cam_service_proto']=='crt') {
    $rkey=crt_session_request_add($sobj, $ccfg['pid'], $sobj['cid']);
    if (is_string($rkey)) {
      session_set_cam_rkey($sobj, $rkey);
      $pk=eproto_packet(eproto_cmd_Interactive);
      $pk['flags']=session_get_reader_type($sobj);
      $pk['payload']=pocket_interactive(from_utf8("Посмотрите\nв камеру"), session_cam_max_time_ms()+500, 0, false);
      $pool->send($sobj['key'], $pk);
    }  
    return true;
  }

  
  if (handler_exec('hcfg_cam', $cfg_cam_params, $cam_cfg)) {
    if (!($rkey=$camfunc($pool, $sobj['key'], REQ_TAG_CAM, $cam_cfg, $cam_url, $sobj['id']))) {
      plogs("cam request fail. link down.\n");
    } else {
      session_set_cam_rkey($sobj, $rkey);
//      logp($glob['log_file'], "session_cam_send_request:\n".var_d($sobj, true)."\n", true);  
      
      if ($gpkey) {
        $pk=eproto_packet(eproto_cmd_Interactive);
        $pk['flags']=session_get_reader_type($sobj);
        $pk['payload']=pocket_interactive(from_utf8("Ожидание\nраспознавания..."), session_cam_max_time_ms()+500, 0, false);
        $pool->send($sobj['key'], $pk);
      } else {
        $pk=eproto_packet(eproto_cmd_Interactive);
        $pk['flags']=session_get_reader_type($sobj);
        $pk['payload']=pocket_interactive(from_utf8("Посмотрите\nв камеру"), session_cam_max_time_ms()+500, 0, false);
        $pool->send($sobj['key'], $pk);
      }
      
      return true;  
    }
  }
  

  session_set_cam_result($sobj, CAM_RES_FAIL);
  return true;  
}

function session_dev_send_pass_request(&$slink, $msg=false, $rce_flags=false, $key=false) {
  global $dmn_main_conn, $glob;
    
  if (!($sobj=&session_obj_get($slink))) return false;
  session_set_passed_data($sobj, NULL);
  
  if (!$key) $key=$sobj['key'];
  if (!$msg) $msg=(string)@$sobj['data']['kpo']['message'];
  $msg=session_fix_allow_message($msg);
  if (!is_int($rce_flags)) $rce_flags=POCKET_RELAY_FLAG_DOWNCOUNT | POCKET_RELAY_FLAG_ZSECOND;
  
  $sobj['ga_params']=array($key, 1, $msg, $sobj['uid'], gat_resp(0x00), false, $rce_flags);
  return ga_a($sobj['ga_params']);
}

function session_dev_send_cancel_text(&$slink, $msg=false, $key=false) {
  global $dmn_main_conn, $glob;
    
  if (!($sobj=&session_obj_get($slink))) return false;
  session_set_passed_data($sobj, NULL);
  
  if (!$key) $key=$sobj['key'];
  if (!$msg) $msg=(string)@$sobj['data']['kpo']['message'];
  $msg=session_fix_error_message($msg);
  
  $sobj['ga_params']=array($key, 0, $msg, $sobj['uid'], gat_resp(0x00), false, 0);
  ga_a($sobj['ga_params']);
  return true;
}

function session_list_filter($uid=false, $key=false, $apkey=false, $logic_and=false) {
  global $glob;
  if ($logic_and && !$uid && !$key) return false;
  $ret=array();
  foreach ($glob[GLOB_KEY_SESSIONS] as &$sobj) {
    if (
      ($uid && $sobj['uid']==$uid) ||
      ($key && ($sobj['key']==$key && (!$apkey || $sobj['apkey']==$apkey)))
    ) if (!$logic_and || 
      ($sobj['uid']==$uid && $sobj['key']==$key && (!$apkey || $sobj['apkey']==$apkey))
    ) $ret[]=&$glob[GLOB_KEY_SESSIONS][$sobj['id']];
  }
  if (count($ret)==0) return false;
  return $ret;
}

function session_oa_list($uid, $key, $apkey=false) {
  global $glob;
  $ret=array();
  if (!is_string($uid) || strlen($uid)<1) return false;
  if (!is_string($key) || strlen($key)<1) return false;
  if (!is_string($apkey) || strlen($apkey)<1) $apkey=false;
  foreach ($glob[GLOB_KEY_SESSIONS] as &$sobj) {
    if ($sobj['uid']!=$uid) continue;
    if ($sobj['key']==$key && (!$apkey || $sobj['apkey']==$apkey)) continue;
    if (!session_is_alive($sobj)) continue;
    if (is_array(@$sobj['passed'])) continue;
    $ret[]=&$glob[GLOB_KEY_SESSIONS][$sobj['id']];
  }
  if (count($ret)==0) return false;
  return $ret;
}

function session_last_by_conn_key($key) {
  $slist=session_list_by_conn_key();
  
}

function session_gen_id() {
   global $glob;
   return 'S'.sprintf("%08X", $glob[GLOB_KEY_SESSIONS_ID_GEN]++);
}

function session_key($uid, $key, $apkey='MAIN') {
  if (strlen((string)@$uid)==0) return false;
  if (strlen((string)@$key)==0) return false;
//  return $uid;
  return $uid.'_'.$key.'_'.$apkey;
}

function session_get_key($key, $uid, &$skey) {
  global $dmn_main_conn, $glob;
  $skey = session_key($uid, $key);
  $oskey=@$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['last_started_session'];
  if ($skey!=$oskey) return false;
  return (array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) && is_array($glob[GLOB_KEY_SESSIONS][$skey]) && @$glob[GLOB_KEY_SESSIONS][$skey]['uid']==$uid);
}

function &session_obj_get(&$slink) {
  global $glob;
  $args=func_get_args();
  $c=count($args);
  $skey=false;
  $sobj=false;

  if ($c==1) {
    if (is_array($slink)) return $slink;
    if (!is_string($slink)) return $sobj;
    if (preg_match('/S[0-9A-Fa-f]{8}/', $slink)) {
      foreach ($glob[GLOB_KEY_SESSIONS] as &$_sobj) {
        if ($_sobj['s_id']==$slink) return $glob[GLOB_KEY_SESSIONS][$_sobj['id']];
      }
      return $sobj;
    }
    $skey=$slink;
  } else if ($c==3) {
    $skey=session_key((string)$args[0], (string)$args[1], (string)$args[2]);
  } else return $sobj;
  if (!$skey || !array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) || !is_array($glob[GLOB_KEY_SESSIONS][$skey])) return $sobj;
  return $glob[GLOB_KEY_SESSIONS][$skey];
}

function _session_calc_expire_time($mtf=false) {
  global $glob;
  if (!$mtf) $mtf=get_mtf();
  $live_time=(float)@$glob['session_expire_time'];
  if ($live_time<=0) $live_time=5.0;
  return $mtf+$live_time;
}

function session_create($uid, $key, $apkey='MAIN', $params=NULL) {
  global $dmn_main_conn, $glob;
  $sobj=array();
  $sobj['id']=session_key($uid, $key);
  $sobj['s_id']=session_gen_id();
  $sobj['key']=$key;
  $sobj['apkey']=$apkey;
  $sobj['uid']=$uid;
  session_kill($sobj['id']);
  $sobj['gat_cmd']=0x00;
  $sobj['time']=get_mtf();
  $sobj['expire_time']=_session_calc_expire_time($sobj['time']);
  $sobj['data']=array('start_time'=>$sobj['time']);
  $sobj['processed']=false;
  $sobj['completed']=false;
  $sobj['log_printed']=false;
  if ($params!==NULL) $sobj['params']=$params;

  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  if ($cobj=&conn_obj_get($sobj['key'])) $cobj['vars']['last_started_session']=$sobj['id'];

  $sobj['lp']=&tlogs_add($conn['con_key'], 
    array(
          'tkey'=>$conn['con_key'], 
          'type'=>'SESSION',
          'id'=>$sobj['id'], 
          's_id'=>$sobj['s_id'], 
          'key'=>$sobj['key'], 
          'apkey'=>$sobj['apkey'], 
          'uid'=>$sobj['uid'], 
          'time'=>$sobj['time'],
          'data'=>$sobj['data'],
         )
    );

  $glob[GLOB_KEY_SESSIONS][$sobj['id']]=$sobj;
  return $sobj['s_id'];
}

function session_kill(&$slink) {
  global $dmn_main_conn, $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
  $skey=$sobj['id'];
  $sobj=false;  
  if (!array_key_exists($skey, $glob[GLOB_KEY_SESSIONS])) return true;
  proxy_set_session_key_by_conkey($dmn_main_conn['pool'], $sobj['key'], false);
  unset($glob[GLOB_KEY_SESSIONS][$skey]);
  return true;
}

function session_get_tid(&$slink) {
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  return $conn['con_key'];
}

function reg_session_csv_event(&$slink, $allow=0, $msg='') {
  global $dmn_main_conn, $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;
  
  $csv_reg_arr = array(
    'session_time'=>date("d.m.y H:i:s", (int)@$sobj['time']),
    'term_id'=>@$conn['id'],
    'term_addr'=>session_get_tid($slink),
    'term_role'=>@$conn['role'],
    'uid'=>@$sobj['data']['rfid']['uid'],
    'kpo_result' => kpo_result_str(@$sobj['data']['kpo']['result']),
    'kpo_msg' => @$sobj['data']['kpo']['message'],
    'cam_result' => cam_result_str(@$sobj['data']['cam']['result']),
    'cam_cid' => (@$sobj['cid'])?$sobj['cid']:((@$sobj['uid']!=@$sobj['data']['rfid']['uid'])?@$sobj['uid']:''),
    'final_result' => ((int)@$sobj['data']['result']>0)?'YES':'NO',
    'final_msg' => (string)@$sobj['data']['message'],
  );
//  logp($glob['log_file'], "reg_session_csv_event:\n".var_d($csv_reg_arr, true)."\n", true);  
  register_csv_event($csv_reg_arr);
//  if (@$sobj['data']['cam']['result']==CAM_RES_NF) register_csv_event($csv_reg_arr, '_no_photo', array('session_time','uid','cam_cid'));
//  if (@$sobj['data']['cam']['result']==CAM_RES_NO) register_csv_event($csv_reg_arr, '_result_no', array('session_time','uid','cam_cid'));
//  if (@$sobj['data']['cam']['result']==CAM_RES_FAIL) register_csv_event($csv_reg_arr, '_fail', array('session_time','uid','cam_cid'));
}

function session_try_tag_read_deny(&$slink) {
  if (handler_exec('tag_read_try_deny', array(&$slink), $h_ret)) return $h_ret;
  return false;
}

function session_try_barcode_read_deny(&$slink) {
  if (handler_exec('barcode_read_try_deny', array(&$slink), $h_ret)) return $h_ret;
  return false;
}

function session_try_faceid_read_deny(&$slink) {
  if (handler_exec('faceid_read_try_deny', array(&$slink), $h_ret)) return $h_ret;
  return false;
}

function session_check_done(&$slink, $call_reason=false) {
  global $dmn_main_conn, $glob;
  
  if (!session_check_wait($slink, $call_reason)) return false;
  
  if (handler_exec('session_cde', array(&$slink, $call_reason), $cde_ret)) return $cde_ret;

  if (!($sobj=&session_obj_get($slink))) return false;
  $sobj['last_done_check']=get_mtf();

//  if (handler_exec('session_cde', array($sobj['id']), $ec)) return $ec;
  
  if (@$sobj['processed'] || @$sobj['completed']) return;
  $mtf=get_mtf();  
  if ($call_reason=='idle') {
    if ((float)@$sobj['expire_time']<$mtf) return session_kill($sobj);
    
  }

  $tid=session_get_tid($sobj['id']);

  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return true;
  $gpkey=cgate_get_op_conn($conn);

  $lp=&session_get_lp($sobj);
  
//  logp($glob['log_file'], "session".$sobj['id']."<");
//  logp($glob['log_file'], "session[".$sobj['key'].":".$sobj['uid']."]:\n".var_d($sobj, true));
//  logp($glob['log_file'], "connection:\n".var_d($glob[GLOB_KEY_CONNECTIONS][$sobj['key']], true));

  $check_kpo=true;
  $check_cam=true;
  $allow=0;
  $msg='Ошибка';
  $rce_flags=POCKET_RELAY_FLAG_DOWNCOUNT | POCKET_RELAY_FLAG_ZSECOND;// | POCKET_RELAY_FLAG_GATE_TRANSFER;


  
  if (@$glob['allow_test_behaviour']===true) {
    if (@$sobj['data']['rfid']['uid']=='E3E933C2') {
      session_set_cam_result($sobj, CAM_RES_NF);
      $msg=from_utf8('НЕТ ФОТО !!!;Обратитесь в;отдел продаж');
      $check_kpo=false;
    	$allow=1;
	    $rce_flags=POCKET_RELAY_FLAG_ZSECOND;
    } else if (@$sobj['data']['rfid']['uid']=='042A70A2984980') {
      $sobj['data']['rfid']['uid']='04236262984980';
      $sobj['uid']='04236262984980';
    }
  } else if (@$glob['allow_test_behaviour']==$tid) {
    session_set_cam_result($sobj, CAM_RES_NF);
    $msg=from_utf8('НЕТ ФОТО !!!;Обратитесь в;отдел продаж');
    $check_kpo=false;
    $allow=1;
	  $rce_flags=POCKET_RELAY_FLAG_ZSECOND;
  }
  
  if (@$sobj['error_message']) {
    $allow=0;
    $msg=$sobj['error_message'];
    $check_kpo=false;
    $check_cam=false;
  }
  
  if (is_array(@$sobj['data']['cam']) && is_array($lp)) {
    $lp['cam_req_data']=$sobj['data']['cam'];
  }

  if ($check_cam && is_array(@$sobj['data']['cam'])) {
    $cam_res=(int)@$sobj['data']['cam']['result'];
    if ($cam_res==CAM_RES_UNDEF) {
      return;
    } else if (@$glob['cam_always_pass']) {
    } else if ($cam_res==CAM_RES_NO) {
      $msg=from_utf8('Лицо;не распознано;Приложите;браслет повторно');
      $check_kpo=false;
    } else if ($cam_res==CAM_RES_NF) {
      $msg=from_utf8('НЕТ ФОТО !!!;Обратитесь в;отдел продаж');
      $check_kpo=false;
  	  $allow=0;
      $rce_flags=POCKET_RELAY_FLAG_ZSECOND;
    } else if ($cam_res==CAM_RES_FAIL) {
      $msg=from_utf8('Приложите;браслет повторно');
//      $msg=from_utf8('Лицо;не распознано!');
      $check_kpo=false;
    }
  }
  
  if ($check_kpo) {
    if ((int)@$sobj['data']['kpo']['result']==KPO_RES_UNDEF) {
      return;
    } else if ($sobj['data']['kpo']['result']==KPO_RES_YES) {
      if ((string)@$sobj['data']['kpo']['message']=='') $sobj['data']['kpo']['message']=$glob['service_fixed_msg'];
      $allow=1;
    } else if ($sobj['data']['kpo']['result']==KPO_RES_NO) {
      $allow=0;
    }
    $msg=@$sobj['data']['kpo']['message'];
  }
//  logp($glob['log_file'], "session1[".$key.":".$uid."]:\n".var_d($sobj, true));

  $ga_key=$sobj['key'];
  if ($gpkey!=false) {
    if (!@$sobj['gate_passed_first']) {
      $sobj['ga_params']=array($ga_key, $allow, $msg, $sobj['uid'], gat_resp(0x00), false, $rce_flags);
      ga_a($sobj['ga_params']);
      return true;
    } else {
      $ga_key=$gpkey;
    }
  }

  $sobj['ga_params']=array($ga_key, $allow, $msg, $sobj['uid'], gat_resp(0x00), false, $rce_flags);
  ga_a($sobj['ga_params']);
  $sobj['processed']=true;
  if (!$sobj['log_printed']) {
    if (is_array(@$conn['lp'])) {
      $conn['lp']['result']=array('allow'=>($allow>0), 'msg'=>$msg,
        'dbrtime'=>(get_mtf()-$sobj['time']),
        'bc_time'=>(@$sobj['data']['cam']['start_time'])?($sobj['data']['cam']['start_time']-$sobj['time']):0,
        'ac_time'=>(@$sobj['data']['cam']['start_time'])?(get_mtf()-$sobj['data']['cam']['start_time']):0,
      );
    }
//    reg_session_csv_event($sobj['id'], $allow, $msg);
    $sobj['log_printed']=true;
  }

//  if (!$allow) session_kill($obj);
}

function dmnh_session_int_event($params=false) {
  global $dmn_main_conn, $glob;
  if (!is_array($params) || count($params)<5) return false;
  $slink=&$params[0];
  $pool=&$params[1];
  $key=$params[2];
  $data=$params[3];
  $evt=$params[4];
  
  if (!($sobj=&session_obj_get($slink))) return false;
//  if (@$sobj['processed'] || @$sobj['completed']) return;
  $tid=session_get_tid($sobj['id']);
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return true;
  $gpkey=cgate_get_op_conn($conn);

  $lp=&session_get_lp($sobj);


  
  return true;
}

function session_wait_done(&$slink) {
  global $dmn_main_conn, $glob;
  if ($sobj=&session_obj_get($slink)) {
//    logp($glob['log_file'], "session_wait_done:\n".var_d($sobj, true)."\n", true);
    if (array_key_exists('wait', $sobj) && is_array($sobj['wait'])) {
      if (@array_key_exists('dst_stage', $sobj['wait'])) {
        $sobj['stage']=$sobj['wait']['dst_stage'];
      } else session_done($sobj);
      unset($sobj['wait']);
    }
  }
  return true;
}

function session_done(&$slink) {
  global $dmn_main_conn, $glob;
  if (!($sobj=&session_obj_get($slink))) return false;
  if (@$sobj['stage']=='done') return false;
  $prev_stage=@$sobj['stage'];
  $sobj['stage']='done';
  if (handler_exec('session_done', array(&$sobj, $prev_stage), $cde_ret)) return $cde_ret;
  return true;
}

function &session_get_wait(&$slink) {
  global $dmn_main_conn, $glob;
  $res=false;
  if (!($sobj=&session_obj_get($slink))) return $res;
  if (@$sobj['processed'] || @$sobj['completed']) return $res;
  if (!is_array(@$sobj['wait'])) return $res;
  return $sobj['wait'];
}

function session_check_wait(&$slink, $call_reason=false) {
  global $dmn_main_conn, $glob;
  if (!($sobj=&session_obj_get($slink))) return false;

  if (@$sobj['processed'] || @$sobj['completed']) return false;

  $pool=$dmn_main_conn['pool'];
  if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return false;

  $mtf=get_mtf();  
  if ($call_reason=='idle') {
    if ((float)@$sobj['expire_time']<$mtf) {
      session_kill($sobj);
      return false;
    }
    if ((float)@$sobj['last_done_check']>($mtf-0.2)) return false;
    if (@$sobj['gp_locked'] && (float)@$sobj['gp_lock_sent']<($mtf-0.5)) {
        session_send_lock_signal($sobj);
//        logp($glob['log_file'], "session_idle_proc:\n".var_d($sobj, true)."\n", true);
    }
    if (@$sobj['stage']!='done' && is_array(@$sobj['dev_locked']) && count($sobj['dev_locked'])>0 && (float)@$sobj['dev_lock_sent']<($mtf-0.5)) {
      $lkeys=session_interactive_dev_lkeys($sobj);
      if (is_array($lkeys)) session_send_dev_lock($sobj, $lkeys);
      $sobj['dev_lock_sent']=get_mtf();
    }
  }

  $sobj['last_done_check']=get_mtf();
  
  if (!is_array(@$sobj['wait'])) return true;
  
  if (@$sobj['wait']['proc']==SESSION_PROC_KPO) {
    if (@$sobj['data']['kpo']['result']!==KPO_RES_UNDEF) return session_wait_done($sobj);
    $et=(float)@$sobj['wait']['expire_time'];
    if ($et<=0 || $et>$mtf) return false;
    if (@$glob['service_autofix_expired']) {
      session_set_kpo_result($sobj, KPO_RES_YES, $glob['service_fixed_msg'], array('kpo_answer_data'=>'autofix'));
      $sobj['ap_mode']=true;
    } else {
      session_set_kpo_result($sobj, KPO_RES_NO, $glob['service_link_err_msg'], array('kpo_answer_data'=>'link error'));
    }
    return session_wait_done($sobj);
  }

  if (@$sobj['wait']['proc']==SESSION_PROC_CAM) {
//    logp($glob['log_file'], "session_check_wait:\n".var_d($sobj, true)."\n", true);
    if (@$sobj['data']['cam']['result']!==CAM_RES_UNDEF) return session_wait_done($sobj);
    $et=(float)@$sobj['wait']['expire_time'];
    if ($et<=0 || $et>$mtf) return false;
    session_set_cam_result($sobj, CAM_RES_NO, array('cam_answer_data'=>'idle_timeout'));
    return session_wait_done($sobj);
  }

  if (@$sobj['wait']['proc']==SESSION_PROC_PASS) {
//    logp($glob['log_file'], "session_check_wait:\n".var_d($sobj, true)."\n", true);
    if (is_array(@$sobj['passed'])) {
      $key=@$sobj['wait']['params']['key'];
      if (!$key || $key==@$sobj['passed']['key']) return session_wait_done($sobj);
    }
    $et=(float)@$sobj['wait']['expire_time'];
    if ($et<=0 || $et>$mtf) return false;
    
    $pdata=array('passed'=>false, 'time'=>get_mtf(), 'tmo'=>true);
    $key=@$sobj['wait']['params']['key'];
    if ($key) $pdata['key']=$key;
    
    session_set_passed_data($sobj, $pdata);
    return session_wait_done($sobj);
  }
  
  return true;
}

function session_wait(&$slink, $proc_type, $dst_stage, $timeout=false, $params=false) {
  global $dmn_main_conn, $glob;
//  logp($glob['log_file'], "session_wait 0:\n".var_d(array($proc_type, $dst_stage, $timeout), true)."\n", true);
  if (!($sobj=&session_obj_get($slink))) return false;
  if (@$sobj['processed'] || @$sobj['completed']) return false;
  if (is_int($timeout)) $timeout=(float)$timeout+0.0;
  if (!is_float($timeout) || $timeout<0.0) {
    $timeout=-0.1;
    if ($proc_type==SESSION_PROC_KPO) $timeout=(float)$glob['kpo_request_expire_time'];
    if ($proc_type==SESSION_PROC_CAM) $timeout=(float)@$glob['cam_service_expire_time'];
    if ($proc_type==SESSION_PROC_PASS) $timeout=session_pass_time($slink)+(float)@$glob['term_pass_add_expire_time'];
  }
  if (!is_float($timeout) || $timeout<0.0) $timeout=0.1;
  
  $sobj['wait']=array(
    'proc'=>$proc_type,
    'expire_time'=>get_mtf()+(float)$timeout,
    'dst_stage'=>$dst_stage,
    'params'=>$params,
  );

//  logp($glob['log_file'], "session_wait:\n".var_d($sobj, true)."\n", true);
  
  return true;
}
   
function session_idle_proc(&$pool, $mtf) {
  global $glob;
    
  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    session_check_done($glob[GLOB_KEY_SESSIONS][$skey], 'idle');
    if (is_array(@$glob[GLOB_KEY_SESSIONS][$skey]) && (float)@$glob[GLOB_KEY_SESSIONS][$skey]['expire_time']<$mtf) {
      session_kill($glob[GLOB_KEY_SESSIONS][$skey]);
    }
  }

}

} // end incl_h
?>
