<?php
if (!defined("INC_SPHINX_INL_H")){
   define("INC_SPHINX_INL_H", TRUE);

   include("hexutil.inc");
   
   define('SPHINX_WAC_NONE', 0x00);
   define('SPHINX_WAC_AUTH', 0x01);
   define('SPHINX_WAC_DELEGATION_START', 0x02);
   define('SPHINX_WAC_DELEGATION_END', 0x03);
   define('SPHINX_WAC_SUBSCRIBE', 0x04);
   define('SPHINX_WAC_UNSUBSCRIBE', 0x05);
   
   define('SPHINX_EMU_DONE_TIMEOUT', 10000);

   define('SPHINX_PING_INT_MIN', 0x05);
   define('SPHINX_PING_INT_MAX', 0x78);
   define('SPHINX_PING_TMO_MIN', 0x05);
   define('SPHINX_PING_TMO_MAX', 0x1E);

   define('SPHINX_APRT_NORMAL', 'NORMAL');
   define('SPHINX_APRT_ESCORT', 'ESCORT');
   
function sphinx_init() {
  global $dmn_main_conn, $glob;
  $glob['sphinx_connections']=array();
  return true;
}  

function sphinx_get_con_key_by_id($id) {
  global $glob;
  foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $key) {
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id']==$id) return $key;
  }
  return false;
}
   
function sphinx_get_session_key_by_id($id) {
  global $glob;
  $ckey=sphinx_get_con_key_by_id($id);
  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function sphinx_start_session($key, $uid, $ticket) {
  global $dmn_main_conn, $glob;
  $skey=session_create($uid, $key);
  if (!$skey) return false;
    
  $glob[GLOB_KEY_SESSIONS][$skey]['data']['rfid']=$uid;

  $os='Read Tag ['.$uid."]\n";
  plogs($os);

  session_set_kpo_result($glob[GLOB_KEY_SESSIONS][$skey], KPO_RES_UNDEF);
  $glob[GLOB_KEY_SESSIONS][$skey]['ap_mode']=false;
  $glob[GLOB_KEY_SESSIONS][$skey]['req_time']=get_mtf();
  session_check_done($skey);
  return $skey;
}

function sphinx_set_autoping(&$pool, $key, $interval, $timeout) {
  global $glob;
  if (@$pool->list[$key]['connected']) {
    $vars=&$glob['sphinx_connections'][$key];
    $vars['ping_interval']=$interval;
    $vars['ping_timeout']=$timeout;
    $vars['last_sent_time']=get_mtf();
    sphinx_upd_autoping($pool, $key, 2);
//    print("\n".var_export($vars, true)."\n");
  }
  return $key;
}

function sphinx_get_tick() {
  return (int)(get_mtf()*1000);
}

function sphinx_upd_autoping(&$pool, $key, $reset=0) {
  global $glob;
  if (!@$pool->list[$key]['connected']) return 0;
  $vars=&$glob['sphinx_connections'][$key];
    
  $ts=sphinx_get_tick();
    
  if ($reset!=0) {
    $vars['ping_sent']=0;
    $vars['ping_timer']=0;
    if ($reset>1) $vars['ping_since_last']=0;
    $vars['ping_timer_']=sphinx_get_tick();
  }
  
  $e_ms=$ts-$vars['ping_timer_'];
  $e_s=(int)($e_ms/1000);
  
  if ($e_s) {
    $vars['ping_timer']+=$e_s;
    $vars['ping_since_last']+=$e_s;
  
    $e_ms-=$e_s*1000;
    $vars['ping_timer_']=$ts-$e_ms;
    return 1;
  }
  return 0;
}

function sphinx_check_autoping(&$pool, $key) {
  global $glob;
  if (!sphinx_upd_autoping($pool, $key, 0)) return;
  if (!@$pool->list[$key]['connected']) return;
  $vars=&$glob['sphinx_connections'][$key];
  if ($vars['ping_sent'] && $vars['ping_timeout']>0 && $vars['ping_since_last']>=$vars['ping_timeout']) {
    $vars['ping_interval']=0;
    $vars['ping_timeout']=0;
    $pool->drop_connection($key, 'ping timeout.');
  } else if (!$vars['ping_sent'] && $vars['ping_interval']>0 && $vars['ping_timer']>=$vars['ping_interval']) {
    sphinx_send($key, 'DELEGATION_START');
//    sphinx_send($key, 'GETAPLIST');
//    sphinx_send($key, 'GETZONEINFO');
    sphinx_upd_autoping($pool, $key, 2);
    $vars['ping_sent']=1;
//    print("txp autoping:[".$key."]\n");
  }
}

function sphinx_on_connect(&$pool, $key) {
  global $glob;
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("sphinx client connected [".$key."]: [".$addr.":".$port."]\n");
  $glob['sphinx_connections'][$key]=array();
  $vars=&$glob['sphinx_connections'][$key];
  $vars['con_evt_time']=get_mtf();    
  $vars['ping_interval']=0;
  $vars['ping_timeout']=0;
  $vars['ping_timer']=0;
  $vars['ping_since_last']=0;
  $vars['ping_timer_']=0;
  $vars['ping_sent']=0;
  $vars['wait_for_answer']=SPHINX_WAC_NONE;
  sphinx_send($key, 'LOGIN', '1.7', '"Administrator"', '""');
  $vars['wait_for_answer']=SPHINX_WAC_AUTH;
  sphinx_set_autoping($pool, $key, 5, 10);
}

function sphinx_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  plogs("sphinx client disconnected [".$key."]\n");
  if (array_key_exists($key, $glob['sphinx_connections'])) unset($glob['sphinx_connections'][$key]);
}
   
function sphinx_decode_packet($data) {
  $ret=explode(' ', $data);
  if (count($ret)==0) return array();
  $cmd=strtoupper(trim((string)array_shift($ret)));
  if (strlen($cmd)==0 || preg_match('/[^A-Z0-9\-\_\.]/', $cmd)) return array();
  array_unshift($ret, $cmd);
  return $ret;
}
   
function sphinx_encode_packet($pk) {
  if (!is_array($pk) || count($pk)==0) return '';
  $pk[0]=strtoupper(trim($pk[0]));
  return implode(' ', $pk)."\r\n";
}
   
function sphinx_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
   $offset=0;
   $prlog=!@$glob['llock'];
   
   $delim="\n";
   $pos=strpos($buffer, $delim);
   if (!is_int($pos)) return false;
   $readed=$pos+strlen($delim);
   if ($pos==0) return array();
   $buf=substr($buffer, 0, $pos);
   
   $pk=sphinx_decode_packet(trim($buf));
   if ($pk===false) {
     plogs("txp packet decode error. halting.\n");
     $pool->drop_connection($key, 'txp packet decode error. stream broken.');
     return false;
   }
   $glob[GLOB_KEY_CONNECTIONS][$key]['last_activity_time']=get_mtf();
   if (!is_array($pk)) return $pk;
   sphinx_upd_autoping($pool, $key, 2);

   if ($prlog) logp($glob['log_file'].'.p',
                    "received [".$key.':'.$seq_no."]:\n".   
                    $pool->dump_packet($buf).
                    "\n\nData:\n".
                    var_export($pk, true)."\n", 
                    true);

   return $pk;
}

function sphinx_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

    $prlog=!@$glob['llock'];
    $buf=sphinx_encode_packet($data);
      
    if ($prlog) logp($glob['log_file'].'.p',
                     "sended [".$key.':'.$seq_no."]:\n".   
                     $pool->dump_packet($buf).
                     "\n\nData:\n".
                     var_export($data, true)."\n", 
                     true);
//   plogs("sended:\n".var_export($data, true));
    return $buf;
}

function sphinx_send() {
  global $dmn_main_conn, $glob;
  $args=func_get_args();
  $key=array_shift($args);
  $dmn_main_conn['pool']->send($key, $args);
  return false;
}

function sphinx_trim_zeroes($uid) {
  return preg_replace('/([\x00]+$)/', '', $uid);
  $_uid=hexutil_hex2buf($uid);	
  if (!$_uid) return $uid;
  $_uid=preg_replace('/(^[\x00]+)|([\x00]+$)/', '', $_uid);
  return hexutil_buf2hex($_uid);
}


function sphinx_on_data(&$pool, $key) {
  global $dmn_main_conn, $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
   if (@$data[0]!=='APLIST' && @$data[0]!=='OK') plogs("data:\n".var_export($data, true)."\n");
//   plogs("raw_data:\n".var_export($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_export($data[2], true)."\n", true);
   if (count($data)==0) return false;
   $cmd=array_shift($data);
   $vars=&$glob['sphinx_connections'][$key];

   if ($vars['wait_for_answer']==SPHINX_WAC_AUTH) {
     if ($cmd=='OK') {
       plogs("sphinx auth OK.\n");
//       $vars['wait_for_answer']=SPHINX_WAC_NONE; return true;
//       sphinx_send($key, 'SUBSCRIBE', 'CE');
//       $vars['wait_for_answer']=SPHINX_WAC_SUBSCRIBE;
       sphinx_send($key, 'DELEGATION_START');
       $vars['wait_for_answer']=SPHINX_WAC_DELEGATION_START;
     } else {
       $pool->drop_connection($key, 'sphinx auth fail.');
       return false;
     }
   } else if ($vars['wait_for_answer']==SPHINX_WAC_SUBSCRIBE) {
     if ($cmd=='OK') {
       plogs("sphinx subscription started.\n");
       sphinx_send($key, 'DELEGATION_START');
       $vars['wait_for_answer']=SPHINX_WAC_DELEGATION_START;
     } else {
       $pool->drop_connection($key, 'sphinx delegation fail.');
       return false;
     }
   } else if ($vars['wait_for_answer']==SPHINX_WAC_DELEGATION_START) {
     if ($cmd=='OK') {
       plogs("sphinx delegation started.\n");
       $vars['wait_for_answer']=SPHINX_WAC_NONE;
     } else {
       $pool->drop_connection($key, 'sphinx delegation fail.');
       return false;
     }
   }
   
   if ($cmd=='DELEGATION_REQUEST') {
     $ticket=trim((string)array_shift($data));
     $ap_request_type=strtoupper(trim((string)array_shift($data)));
     if ($ap_request_type==SPHINX_APRT_NORMAL) {
      if (count($data)<3) {
//        $pool->drop_connection($key, 'delegation request missing parameters');
        return false;
      }
      $req_key_id = trim((string)array_shift($data));
      $req_key = '';
      if ($req_key_id=='W26') {
        $req_key_f = (int)@trim((string)array_shift($data));
        $req_key_l = (int)@trim((string)array_shift($data));
        if ($req_key_f>0 && $req_key_l>0) {
          $req_key = numcoder_encode_r($req_key_l, 2).numcoder_encode_r($req_key_f, 1);
        }
      } else if ($req_key_id=='W34') {
        $req_key=hexutil_hex2buf(trim((string)@array_shift($data)));
      } else if ($req_key_id=='ID') {
        $req_key=trim((string)@array_shift($data));
        return false;
      }
      if (count($data)<3) {
//        $pool->drop_connection($key, 'delegation request missing parameters');
        return false;
      }
      $dir = trim((string)array_shift($data));
      $apid = trim((string)array_shift($data));
      $extra_rd = trim((string)array_shift($data));
      
      $apkey=$dir.$apid.$extra_rd;

      $uid=sphinx_trim_zeroes($req_key);
      $uid_hex=strtoupper(crypt_str_to_hex($uid));
      
      if (!($conn=&conn_get_settings($key, $apkey, true))) return true;
      if (!@$glob[GLOB_KEY_CONNECTIONS][$key]) return false;

      $glob[GLOB_KEY_CONNECTIONS][$key]['lp']=&tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'apkey'=>$apkey, 'type'=>'TAG_READ', 'time'=>get_mtf(), 'uid'=>$uid_hex, 'params'=>array()));
      
      if ($glob['http_service_active']) {
        if (!handler_exec('hcfg_http', false, $http_cfg)) return true;
        if (!handler_exec('hurl_http', array(REQ_TAG_QRY, &$sobj, &$conn, &$http_cfg, $aparams), $hurl)) return true;
        if (!httpr_new($pool, $key, REQ_TAG_QRY, $http_cfg, $hurl, array($key, $ticket, 0x00))) {
          plogs("http request fail. link down.\n");
        }
        return true;
      }
       
  //     sphinx_start_session($key, $uid_hex, $ticket);
     }
     sphinx_send($key, 'DELEGATION_REPLY', $ticket, 'NORMAL', '255', '0', '0', '0', '0');
   }
   return true;
}

function sphinx_idle_proc(&$pool) {
  global $dmn_main_conn, $glob;
    
  foreach (array_keys($glob['sphinx_connections']) as $key) {
    sphinx_check_autoping($pool, $key);
  }
}
   

} // end incl_h
?>
