<?php
if (!defined("INC_TERM_INL_H")){
  define("INC_TERM_INL_H", TRUE);

define('TTYPE_GAT', 'gat');
define('TTYPE_POCKET', 'pocket');
define('TTYPE_SPHINX', 'sphinx');
define('TTYPE_JSP', 'jsp');

function term_parse_ttype($ttype) {
  $ttype=strtolower(trim(@(string)$ttype));
  $ret=TTYPE_GAT;
  if ($ttype==TTYPE_GAT) {
    $ret=TTYPE_GAT;
  } else if ($ttype==TTYPE_POCKET) {
    $ret=TTYPE_POCKET;
  } else if ($ttype==TTYPE_SPHINX) {
    $ret=TTYPE_SPHINX;
  } else if ($ttype==TTYPE_JSP) {
    $ret=TTYPE_JSP;
  }
  return $ret;
}

function term_parse_aval($aval) {
  $aval=trim($aval);
  $av=explode(',', $aval);
  $lc=strtolower($aval);
  $iv=(int)$lc;
  $fv=(float)$lc;
  if (is_array($av) && count($av)>1) {
    $aval=array();
    foreach ($av as $item) $aval[]=term_parse_aval($item);
  } else if ($lc=='') {
    $aval=false;
  } else if ($lc=='false') {
    $aval=false;
  } else if ($lc=='true') {
    $aval=true;
  } else if ($iv.''==$lc) {
    $aval=$iv;
  } else if ($fv.''==$lc) {
    $aval=$fv;
  }  
  return $aval;
}

function term_parse($term) {
  $term=trim($term);
  $ipa=explode(':', $term);
  if (count($ipa)==0) return false;  
  $id=trim(@array_shift($ipa));
  if (count($ipa)==0 || !is_ip($ipa[0])) {
    $ip=$id;
    $id='';
  } else {
    $ip=trim(@array_shift($ipa));
  }
  if (!is_ip($ip)) return false;
  $port=0;
  $utf=false;
  $reg_query=false;
  $ttype=TTYPE_POCKET;
  $pairs=array();
  while ($p=array_shift($ipa)) {
    $p=trim($p);
    if (strlen($p)==0 || $p[0]=='_') continue;
    $a=explode('=', $p, 2);
    if (!is_array($a) || count($a)!=2) $a=false;
    if ((int)$p>0) {
      $port=(int)$p;
    } else if (is_array($a)) {
      $akey=strtolower(trim($a[0]));
      $aval=trim($a[1]);
      if (strlen($akey)>0) $pairs[$akey]=term_parse_aval($aval);
    } else if ($p=='u') {
      $utf=true;
    } else if ($p=='r') {
      $reg_query=true;
    } else {
      $akey=strtolower(trim($p));
      $pairs[$akey]=true;
    }
  }
//  if (strlen($id)==0) $id=gen_id();
  if ($port==0) $port=8080;
  $con_key=$ip.':'.$port;
  
  if (array_key_exists('type', $pairs)) $ttype=term_parse_ttype($pairs['type']);
  $pairs['type']=$ttype;
  
  
  $set=array('con_key'=>$con_key, 'ip'=>$ip, 'port'=>$port, 'config_string'=>$term, 'id'=>$id, 'utf'=>$utf, 'reg_query'=>$reg_query, 'type'=>$ttype);
  foreach ($pairs as $akey=>$aval) $set[$akey]=$aval;
  if (array_key_exists('proxy', $set) && !is_int($set['proxy'])) $set['proxy']=(int)$set['proxy'];
  $ret=array('con_key'=>$con_key, 'ip'=>$ip, 'port'=>$port,
             'settings'=>$set,
            );
  return $ret;
}

function term_parse_list($tlist) {  
    $ret=array();
    foreach ($tlist as $term) {
      if (is_array($term) && is_string(@$term['con_key'])) {
        $ret[$term['con_key']]=$term;
        continue;
      }
      $term=term_parse($term);
      if (!$term) continue;
      $tkey=$term['con_key'];
      if (!array_key_exists($tkey, $ret)) $ret[$tkey]=$term;
      if (array_key_exists('apkey', $term['settings'])) {
        if (!is_array(@$ret[$tkey]['apkeys'])) $ret[$tkey]['apkeys']=array();
        $ret[$tkey]['apkeys'][$term['settings']['apkey']]=$term['settings'];
      } else if (!array_key_exists('apkey', $ret[$tkey]['settings'])) $ret[$tkey]['settings']['apkey']='MAIN';
    }
//    global $glob; logp($glob['log_file'],"\n\nTList:\n".var_export($ret, true)."\n", true);exit(0);
    return $ret;
}

function term_filter_pass($tstr) {
  global $glob;
//  logp($glob['log_file'], "ipfilter#1 [".$tstr."]:\n", true);
  if (!@$glob['term_list_filter']) return true;
//  logp($glob['log_file'], "ipfilter#2 [".$tstr."]:\n", true);
  $abs=(@$glob['term_list_filter_absent']===true)?true:false;
//  logp($glob['log_file'], "ipfilter#3 [".$tstr."]:[".var_d($abs, true)."]\n", true);
  $m=preg_match($glob['term_list_filter'], $tstr)?true:false;
//  logp($glob['log_file'], "ipfilter#4 [".$tstr."]:[".var_d($m, true)."]\n", true);
  return $m!=$abs;
}

function term_filter_list($tlist) {
  global $glob;
  $ret=array();
//  logp($glob['log_file'], "ipfilter#0 [".$tstr."]:[".var_d($tlist, true)."]\n", true);
  foreach ($tlist as $tstr) if (term_filter_pass($tstr)) $ret[]=$tstr;
  return $ret;
}
  
} // end incl_h
?>
