<?php
if (!defined("INC_TXP_INL_H")){
   define("INC_TXP_INL_H", TRUE);

   include("hexutil.inc");
   
   
   define('TXP_RTYPE_REQUEST', 0x01);
   define('TXP_RTYPE_RESPONSE', 0x02);
   define('TXP_RTYPE_TRANSACTION', 0x03);
   define('TXP_RTYPE_PANIC', 0x04);
   define('TXP_RTYPE_ASYNC', 0x05);

   define('TXP_EMU_DONE_TIMEOUT', 10000);

   define('TXP_PING_INT_MIN', 0x05);
   define('TXP_PING_INT_MAX', 0x78);
   define('TXP_PING_TMO_MIN', 0x05);
   define('TXP_PING_TMO_MAX', 0x1E);
   
function txp_init() {
  global $dmn_main_conn, $glob;
  $glob['txp_server_key']=false;
  $glob['txp_subscriber_key']=false;
  $glob['txp_debug_key']=false;
  $glob['txp_emu_sessions']=array();
  $glob['txp_connections']=array();
  
  $ulp=(int)@$glob['txp_listener_port'];
  if ($ulp>0) {
    $ukey=$dmn_main_conn['pool']->start_server($dmn_main_conn['srvaddr'], $ulp, $err_code, $err_str);
    if ($ukey!==false) {
      $glob['txp_server_key']=$ukey;
    } else {
      plogs("cannot start txp server. halting...");
      $dmn_main_conn['need_exit']=true;
      return false;
    }
  }
  return true;
}  
   
function txp_get_con_key_by_id($id) {
  global $glob;
  foreach (array_keys($glob[GLOB_KEY_CONNECTIONS]) as $key) {
    if ($glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id']==$id) return $key;
  }
  return false;
}

function txp_get_session_key_by_id($id) {
  global $glob;
  plogs('txp dbg 1:'.var_d($id)."\n");
  $cset=&conn_get_settings_by_id($id);
  plogs('txp dbg 2:'.var_d($cset)."\n");
  $skey=@$glob[GLOB_KEY_CONNECTIONS][$cset['key']]['vars']['last_started_session'];
  plogs('txp dbg 3:'.var_d($skey)."\n");
  plogs('txp dbg 4:'.var_d(@$glob[GLOB_KEY_SESSIONS][$skey])."\n");
  if ($skey && array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) && !@$glob[GLOB_KEY_SESSIONS][$skey]['processed']) return $skey;
  return false;

  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function txp_get_session_key_by_id1($id) {
  global $glob;
  $ckey=txp_get_con_key_by_id($id);
  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function txp_start_session($key, $uid) {
  global $dmn_main_conn, $glob;
  $skey=session_create($key, $uid);
  if (!$skey) return false;
    
  $glob[GLOB_KEY_SESSIONS][$skey]['data']['rfid']=$uid;

  $os='Read Tag ['.uid2hex($uid)."]\n";
  plogs($os);
    
  $glob[GLOB_KEY_SESSIONS][$skey]['kpo_result']=KPO_RES_UNDEF;
  $glob[GLOB_KEY_SESSIONS][$skey]['ap_mode']=false;
  $glob[GLOB_KEY_SESSIONS][$skey]['req_time']=get_mtf();
  session_check_done($skey);
  return $skey;
}

function txp_set_autoping(&$pool, $key, $interval, $timeout) {
  global $glob;
  if (@$pool->list[$key]['connected']) {
    $vars=&$glob['txp_connections'][$key];
    $vars['ping_interval']=$interval;
    $vars['ping_timeout']=$timeout;
    $vars['last_sent_time']=get_mtf();
    txp_upd_autoping($pool, $key, 2);
//    print("\n".var_export($vars, true)."\n");
  }
  return $key;
}

function txp_get_tick() {
  return (int)(get_mtf()*1000);
}

function txp_upd_autoping(&$pool, $key, $reset=0) {
  global $glob;
  if (!@$pool->list[$key]['connected']) return 0;
  $vars=&$glob['txp_connections'][$key];
    
  $ts=txp_get_tick();
    
  if ($reset!=0) {
    $vars['ping_sent']=0;
    $vars['ping_timer']=0;
    if ($reset>1) $vars['ping_since_last']=0;
    $vars['ping_timer_']=txp_get_tick();
  }
  
  $e_ms=$ts-$vars['ping_timer_'];
  $e_s=(int)($e_ms/1000);
  
  if ($e_s) {
    $vars['ping_timer']+=$e_s;
    $vars['ping_since_last']+=$e_s;
  
    $e_ms-=$e_s*1000;
    $vars['ping_timer_']=$ts-$e_ms;
    return 1;
  }
  return 0;
}

function txp_check_autoping(&$pool, $key) {
  global $glob;
  if (!txp_upd_autoping($pool, $key, 0)) return;
  if (!@$pool->list[$key]['connected']) return;
  $vars=&$glob['txp_connections'][$key];
  if ($vars['ping_sent'] && $vars['ping_timeout']>0 && $vars['ping_since_last']>=$vars['ping_timeout']) {
    $vars['ping_interval']=0;
    $vars['ping_timeout']=0;
    $pool->drop_connection($key, 'ping timeout.');
  } else if (!$vars['ping_sent'] && $vars['ping_interval']>0 && $vars['ping_timer']>=$vars['ping_interval']) {
    txp_send($key, 'ping', '');
    txp_upd_autoping($pool, $key, 2);
    $vars['ping_sent']=1;
//    print("txp autoping:[".$key."]\n");
  }
}

function txp_on_connect(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
/*
  if ($glob['txp_subscriber_key']!==false && $key!=$glob['txp_subscriber_key']) {
    plogs("dropping txp secondary connection.\n");
    $pool->drop_connection($key);
    return;
  }

  if ($glob['txp_subscriber_key']!==false) {
    plogs("duplicated txp connect event.\n");
    return;
  }
*/
  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("txp client connected [".$key.":".$srv_key."]: [".$addr.":".$port."]\n");
  $pool->set_socket_handlers($key, 'txp_on_recv', 'txp_on_send', 'txp_on_data', 'txp_on_disconnect');
  $pool->set_socket_low_handlers($key, 'conn_on_low_recv', 'conn_on_low_send');        
//  $glob['txp_subscriber_key']=$key;
//  $glob['txp_con_evt_time']=get_mtf();
  $glob['txp_connections'][$key]=array();
  $vars=&$glob['txp_connections'][$key];
  $vars['con_evt_time']=get_mtf();    
  $vars['ping_interval']=0;
  $vars['ping_timeout']=0;
  $vars['ping_timer']=0;
  $vars['ping_since_last']=0;
  $vars['ping_timer_']=0;
  $vars['ping_sent']=0;
  txp_upd_autoping($pool, $key, 2);
}

function txp_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
/*  
  if ($glob['txp_subscriber_key']===false) {
    plogs("unknown txp disconnect event #1.\n");
    return;
  }
  if ($key!=$glob['txp_subscriber_key']) {
    plogs("unknown txp disconnect event #2.\n");
    return;
  }
*/
  plogs("txp client disconnected [".$key.":".$srv_key."]\n");
  if ($err_code!==0) {
    $es='';
    if (is_integer($err_code)) {
      $es.=' ['.$err_code.':'.cp866(trim(socket_strerror($err_code))).']';
    } else {
      $es.=' ['.$err_code.']';
    }
    plogs($es."\n");
  }
//  $glob['txp_subscriber_key']=false;
//  $glob['txp_con_evt_time']=get_mtf();
  if (array_key_exists($key, $glob['txp_connections'])) unset($glob['txp_connections'][$key]);
}
   
function txp_strip_excl($str) {
  return preg_replace('/!/', '', $str);
}  

function txp_date_str() {
  return log_micro_date('Y-m-d H:i:s');
}

function txp_decode_packet($data) {
  $ret=explode(' ', $data);
  if (count($ret)==0) return array();
  $cmd=strtoupper(trim((string)array_shift($ret)));
  if (strlen($cmd)==0 || preg_match('/[^A-Z0-9\-\_\.]/', $cmd)) return array();
  array_unshift($ret, $cmd);
/*  
  $ret['cmd']=$cmd;
  $ret['params']=$a;
  foreach ($a as $item) {
    $pair=explode('=', $item, 2);
    $key=strtoupper(trim((string)array_shift($pair)));
    $val=(count($pair)>0)?trim((string)array_shift($pair)):true;
    if (is_string($val) && strlen($val)==0) $val=true;
    if (strlen($key)>0 && !preg_match('/[^A-Z0-9\-\_\.]/', $key)) $ret['params'][$key]=$val;
  }
*/  
//  if ($ret['rtype']===false) return false;
  return $ret;
}

function txp_pad_r($str, $count, $symb=' ') {
  $str=(string)@$str; if (strlen($str)>$count) $str=substr($temp, 0, $count); 
  return str_pad($str, $count, $symb, STR_PAD_RIGHT);
}

function txp_pad_l($str, $count, $symb=' ') {
  $str=(string)@$str; if (strlen($str)>$count) $str=substr($temp, 0, $count); 
  return str_pad($str, $count, $symb, STR_PAD_LEFT);
}

function txp_encode_packet($pk) {
  if (!is_array($pk) || count($pk)==0) return '';
  $pk[0]=strtoupper(trim($pk[0]));
  return implode(' ', $pk)."\r\n";
}
   
function txp_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
   $offset=0;
   $prlog=!@$glob['llock'];
   
   $delim="\n";
   $pos=strpos($buffer, $delim);
   if (!is_int($pos)) return false;
   $readed=$pos+strlen($delim);
   if ($pos==0) return array();
   $buf=substr($buffer, 0, $pos);
   
   $pk=txp_decode_packet(trim($buf));
   if ($pk===false) {
     plogs("txp packet decode error. halting.\n");
     $pool->drop_connection($key, 'txp packet decode error. stream broken.');
     return false;
   }
   if (!is_array($pk)) return $pk;
   txp_upd_autoping($pool, $key, 2);

   if ($prlog) logp($glob['log_file'].'.p',
                    "received [".$key.':'.$seq_no."]:\n".   
                    $pool->dump_packet($buf).
                    "\n\nData:\n".
                    var_export($pk, true)."\n", 
                    true);

   return $pk;
}

function txp_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

    $prlog=!@$glob['llock'];
    $buf=txp_encode_packet($data);
      
    if ($prlog) logp($glob['log_file'].'.p',
                     "sended [".$key.':'.$seq_no."]:\n".   
                     $pool->dump_packet($buf).
                     "\n\nData:\n".
                     var_export($data, true)."\n", 
                     true);
//   plogs("sended:\n".var_export($data, true));
    return $buf;
}

function txp_send() {
  global $dmn_main_conn, $glob;
  $args=func_get_args();
  $key=array_shift($args);
  $dmn_main_conn['pool']->send($key, $args);
  return false;
}

function txp_on_data(&$pool, $key) {
  global $dmn_main_conn, $glob;
//function on_data(&$pool, $key, $data, $seq_no) {
   global $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
   $_data=$data[0];
   plogs("txp data:\n".var_export($_data, true)."\n");
//   plogs("raw_data:\n".var_export($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_export($data[2], true)."\n", true);
   if (count($data)==0) return false;
   $cmd=array_shift($data);
   if ($cmd=='ROLE') {
     if (count($data)==0) {
       if ($glob['txp_subscriber_key']==$key) $glob['txp_subscriber_key']=false;
       if ($glob['txp_debug_key']==$key) $glob['txp_debug_key']=false;       
       return txp_send($key, 'ok', 'You are nobody now');
     }
     $role=strtoupper(trim((string)array_shift($data)));
     if ($role=='SUBSCRIBER') {
       if ($glob['txp_debug_key']==$key) $glob['txp_debug_key']=false;
       $glob['txp_subscriber_key']=$key;
       return txp_send($key, 'ok', 'You are subscriber now');
     } else if ($role=='DEBUGGER') {
       if ($glob['txp_subscriber_key']==$key) $glob['txp_subscriber_key']=false;
       $glob['txp_debug_key']=$key;
       return txp_send($key, 'ok', 'You are debugger now');
     } else {
       return txp_send($key, 'error', 'Unknown role');
     }
   } else if ($cmd=='SESSION_REPLY') {
     if (count($data)<3) return txp_send($key, 'error', 'Missed parameters');

     $id=trim((string)array_shift($data));
     $skey=txp_get_session_key_by_id($id);
     if (!$skey) return txp_send($key, 'error', 'Session not found');
     if (!($sobj=&session_obj_get($skey))) return txp_send($key, 'error', 'Session not found');
     if (!($conn=&conn_get_settings($sobj['key'], $sobj['apkey'], true))) return true;
     $gpkey=cgate_get_op_conn($conn);

     $_uid=trim((string)array_shift($data));
     $uid=hexutil_hex2buf($_uid);
     if ($uid==false) {
       $result=$_uid;
       $uid=false;
     } else {
       if (strlen($uid)>32) $uid=substr($uid, 0, 32);
       $result=trim((string)array_shift($data));
     }
     $result=strtoupper($result);
     if (strlen($result)!=1) return txp_send($key, 'error', 'Unrecognized result');

     $cid=trim((string)array_shift($data));

     $text=implode(' ', $data);
     session_set_kpo_result($sobj, ($result=='Y' || (int)$result>0)?KPO_RES_YES:KPO_RES_NO, $text, array('kpo_answer_data'=>$_data));
     if ($uid!==false) {
       $sobj['uid']=$uid;
       $sobj['uid_hex']=hexutil_buf2hex($uid);
     } else if (strlen($cid)>0) {
       $sobj['cid']=$cid;
     }
     session_check_done($skey);
     txp_send($key, 'ok', 'Answer accepted');
     return true;     
   } else if ($cmd=='SESSION_HALT') {
     if (count($data)<1) return txp_send($key, 'error', 'Missed parameters');

     $id=trim((string)array_shift($data));
     $skey=txp_get_session_key_by_id($id);
     if (!$skey) return txp_send($key, 'error', 'Session not found');

     session_kill($skey);
     txp_send($key, 'ok', 'Session killed');
     return true;
   } else if ($cmd=='EMULATE') {
     if (count($data)<1) return txp_send($key, 'error', 'Missed parameters');

     $id=trim((string)array_shift($data));
     $ckey=txp_get_con_key_by_id($id);
     if (!$ckey) return txp_send($key, 'error', 'Connection not found');
     
     $_uid=trim((string)array_shift($data));
     $uid=hexutil_hex2buf($_uid);
     if ($uid==false || strlen($uid)>32) return txp_send($key, 'error', 'Invalid uid');
     if (!@$glob['txp_subscriber_key']) return txp_send($key, 'error', 'There is no subscriber now');
     
     $skey=txp_start_session($ckey, $uid);
     if (!$skey) return txp_send($key, 'error', 'Failed to create session');
     txp_send($key, 'ok', 'Emulated session started');
     txp_send($glob['txp_subscriber_key'], 'SESSION_START', $id, $glob[GLOB_KEY_SESSIONS][$skey]['uid_hex']);
     return true;
   } else if ($cmd=='PING') {
     if (count($data)>1) {
       $ping_int=hexutil_hex2buf(trim((string)array_shift($data)));
       $ping_int=(strlen($ping_int)>0)?ord($ping_int{0}):0;
       if ($ping_int<TXP_PING_INT_MIN || $ping_int>TXP_PING_INT_MAX) return txp_send($key, 'error', 'Invalid ping interval');
       $ping_tmo=hexutil_hex2buf(trim((string)array_shift($data)));
       $ping_tmo=(strlen($ping_tmo)>0)?ord($ping_tmo{0}):0;
       $ping_tmo_d=$ping_tmo-$ping_int;
       if ($ping_tmo_d<TXP_PING_TMO_MIN || $ping_tmo_d>TXP_PING_TMO_MAX) return txp_send($key, 'error', 'Invalid ping timeout');

       txp_set_autoping($pool, $key, $ping_int, $ping_tmo);
       txp_send($key, 'ok', 'Autoping started');
       return true;
     } else if (count($data)>0) {
       txp_send($key, 'ok', 'Ping echo: '.trim((string)array_shift($data)));
       return true;
     }
     txp_send($key, 'ok', 'Ping catched');
     return true;
   } else if ($cmd=='Y') {
     $skey=txp_get_session_key_by_id(@$data['addr']);
     if ($skey) {
       if (!($sobj=&session_obj_get($skey))) return true;
       session_set_kpo_result($sobj, (@$data['result']=='Y' || (int)@$data['result']>0)?KPO_RES_YES:KPO_RES_NO, $data['str1']."\n".$data['str2'], array('kpo_answer_data'=>$_data));
       $ticket=trim(@$data['ticket']);
       if (strlen($ticket)>0 && $sobj['data']['kpo']['result']==KPO_RES_YES) {
//         $glob[GLOB_KEY_SESSIONS][$skey]['uid']=$ticket;
//         $glob[GLOB_KEY_SESSIONS][$skey]['uid_hex']=$ticket;
         if (@$glob['cam_service_active'] && !@array_key_exists('result', @$sobj['data']['cam'])) {
           cam_start_process_light($pool, $glob[GLOB_KEY_SESSIONS][$skey]['key'], session_get_tid($skey), $glob[GLOB_KEY_SESSIONS][$skey]['uid_hex'], $ticket, $skey);
         }
       } else if (@array_key_exists('cam_result', $glob[GLOB_KEY_SESSIONS][$skey])) unset($glob[GLOB_KEY_SESSIONS][$skey]['cam_result']);
       
       session_check_done($skey);
       return true;
     }
   }
   return true;
}

function txp_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;
    
  foreach (array_keys($glob['txp_connections']) as $key) {
    txp_check_autoping($pool, $key);
  }

}
   
function txp_request_answer($result, $message, $skey) {
  global $dmn_main_conn, $glob;
  
  
  
}


} // end incl_h
?>
