<?php
if (!defined("INC_UCS_INL_H")){
   define("INC_UCS_INL_H", TRUE);

   define('UCS_RTYPE_REQUEST', 0x01);
   define('UCS_RTYPE_RESPONSE', 0x02);
   define('UCS_RTYPE_TRANSACTION', 0x03);
   define('UCS_RTYPE_PANIC', 0x04);
   define('UCS_RTYPE_ASYNC', 0x05);

   define('UCS_CANCEL_SYMBOL', '5');

   define('UCS_SENT_REQUEST_KEY', '_ucs_sent_request');
   define('UCS_SENT_TRANSACTION_KEY', '_ucs_sent_transaction');

function ucs_init() {
  global $dmn_main_conn, $glob;
  $glob['ucs_server_key']=false;
  $glob['ucs_child_key']=false;

  $ulp=(int)@$glob['ucs_listener_port'];
  if ($ulp>0) {
    $ukey=$dmn_main_conn['pool']->start_server($dmn_main_conn['srvaddr'], $ulp, $err_code, $err_str);
    if ($ukey!==false) {
      $glob['ucs_server_key']=$ukey;
    } else {
      plogs("cannot start ucs server. halting...");
      $dmn_main_conn['need_exit']=true;
      return false;
    }
  }
  return true;
}  
   
function ucs_send_request(&$pool, $uid, $id, $dir) {
  global $glob;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_request:\n".var_d(array($uid, $id, $dir), true)."\n", true);
  if (!@$glob['ucs_child_key']) return false;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_request #1:\n", true);
  if (!($cset=&conn_get_settings_by_id($id))) return false;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_request #2:\n".var_d($cset, true)."\n", true);
  $pool->send($glob['ucs_child_key'], ucs_proto_make_request($uid, $id, $dir));
  $cset[UCS_SENT_REQUEST_KEY]=array($uid, $id, $dir);
  $cset[UCS_SENT_TRANSACTION_KEY]=false;
}

function ucs_send_transaction(&$pool, $uid, $id, $dir) {
  global $glob;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_transaction:\n".var_d(array($uid, $id, $dir), true)."\n", true);
  if (!@$glob['ucs_child_key']) return false;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_transaction #1:\n", true);
  if (!($cset=&conn_get_settings_by_id($id))) return false;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_transaction #2:\n".var_d($cset, true)."\n", true);
  if (!@$cset[UCS_SENT_REQUEST_KEY]) return false;
  if (@$glob['log_file_err']) logp($glob['log_file_err'], "ucs_send_transaction #3:\n", true);
  $pool->send($glob['ucs_child_key'], ucs_proto_make_transaction($uid, $id, $dir));
  $cset[UCS_SENT_REQUEST_KEY]=false;
  $cset[UCS_SENT_TRANSACTION_KEY]=array($uid, $id, $dir);
}

function ucs_get_session_key_by_id($id) {
  global $glob;
  $cset=&conn_get_settings_by_id($id);
  $skey=@$glob[GLOB_KEY_CONNECTIONS][$cset['key']]['vars']['last_started_session'];
  if ($skey && array_key_exists($skey, $glob[GLOB_KEY_SESSIONS]) && !@$glob[GLOB_KEY_SESSIONS][$skey]['processed']) return $skey;
  return false;

  foreach (array_keys($glob[GLOB_KEY_SESSIONS]) as $skey) {
    if ($glob[GLOB_KEY_SESSIONS][$skey]['key']==$ckey) return $skey;
  }
  return false;
}

function ucs_on_connect(&$pool, $key) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];

  if ($glob['ucs_child_key']!==false && $key!=$glob['ucs_child_key']) {
    plogs("dropping ucs secondary connection.\n");
    $pool->drop_connection($key);
    return;
  }

  if ($glob['ucs_child_key']!==false) {
    plogs("duplicated ucs connect event.\n");
    return;
  }

  $addr=$pool->list[$key]['addr'];
  $port=$pool->list[$key]['port'];
  plogs("ucs client connected [".$key.":".$srv_key."]: [".$addr.":".$port."]\n");
  $pool->set_socket_handlers($key, 'ucs_on_recv', 'ucs_on_send', 'ucs_on_data', 'ucs_on_disconnect');
  $pool->set_socket_low_handlers($key, 'conn_on_low_recv', 'conn_on_low_send');        
  $glob['ucs_child_key']=$key;
  $glob['ucs_con_evt_time']=get_mtf();    
}

function ucs_on_disconnect(&$pool, $key, $err_code=0) {
  global $glob;
  $srv_key=$pool->list[$key]['srv_key'];
  if ($glob['ucs_child_key']===false) {
    plogs("unknown ucs disconnect event #1.\n");
    return;
  }
  if ($key!=$glob['ucs_child_key']) {
    plogs("unknown ucs disconnect event #2.\n");
    return;
  }
    
  $es='ucs client disconnected ['.$key.':'.$srv_key.']';
  if ($err_code!==0) {
    if (is_integer($err_code)) {
      $es.=' ['.$err_code.':'.cp866(trim(socket_strerror($err_code))).']';
    } else {
      $es.=' ['.$err_code.']';
    }
  }
  plogs($es."\n");
//  plogs("ucs client disconnected [".$key.":".$srv_key."]\n");
  $glob['ucs_child_key']=false;
  $glob['ucs_con_evt_time']=get_mtf();
}
   
function ucs_strip_excl($str) {
  return preg_replace('/!/', '', $str);
}  

function ucs_date_str() {
  return log_micro_date('Y-m-d H:i:s');
}

function ucs_proto_make_request($ticket, $addr, $dir) {
  $ret=array();
  $ret['rtype']=UCS_RTYPE_REQUEST;
  $ret['ticket']=$ticket;
  $ret['addr']=$addr;
  $ret['dir']=$dir;
  $ret['date']=ucs_date_str();
  return $ret;
}
   
function ucs_proto_make_transaction($ticket, $addr, $dir) {
  $ret=array();
  $ret['rtype']=UCS_RTYPE_TRANSACTION;
  $ret['ticket']=$ticket;
  $ret['addr']=$addr;
  $ret['dir']=$dir;
  $ret['date']=ucs_date_str();
  return $ret;
}

function ucs_proto_make_responce($ticket, $addr, $dir, $result='N', $str) {
  $ret=array();
  $ret['rtype']=UCS_RTYPE_RESPONSE;
  $ret['ticket']=$ticket;
  $ret['addr']=$addr;
  $ret['dir']=$dir;
  $ret['date']=ucs_date_str();
  $ret['result']=$result{0};
  
  $sa=str_split($str, 20);
  $ret['str1']=(@$sa[0])?$sa[0]:'';
  $ret['str2']=(@$sa[1])?$sa[1]:'';
  return $ret;
}

function ucs_decode_packet($data) {
  $loffset=strlen($data);
  if ($loffset<128) return false;
  $ret=array();
  $offset=0;
  $ret['rtype']=false;
  $ret['cmd']=$data{$offset++};
  if ($ret['cmd']=='Q') {
    $ret['ticket']=numcoder_decode_buf($data, $offset, 64, $loffset);
    $ret['addr']=numcoder_decode_buf($data, $offset, 2, $loffset);
    $ret['dir']=$data{$offset++};
    $ret['date']=numcoder_decode_buf($data, $offset, 19, $loffset);
    $ret['rtype']=($data{$offset}=='!')?UCS_RTYPE_REQUEST:UCS_RTYPE_RESPONSE;
    if ($ret['rtype']==UCS_RTYPE_RESPONSE) {
      $ret['result']=$data{$offset++};
      $ret['str1']=ucs_strip_excl(numcoder_decode_buf($data, $offset, 20, $loffset));
      $ret['str2']=ucs_strip_excl(numcoder_decode_buf($data, $offset, 20, $loffset));
    }
  } else if ($ret['cmd']=='T') {
    $ret['rtype']=UCS_RTYPE_TRANSACTION;
    $ret['ticket']=numcoder_decode_buf($data, $offset, 64, $loffset);
    $ret['addr']=numcoder_decode_buf($data, $offset, 2, $loffset);
    $ret['dir']=$data{$offset++};
    $ret['date']=numcoder_decode_buf($data, $offset, 19, $loffset);
  } else if ($ret['cmd']=='A') {
    $ret['rtype']=UCS_RTYPE_ASYNC;
    $ret['addr']=numcoder_decode_buf($data, $offset, 2, $loffset);
    $ret['dir']=$data{$offset++};
  } else if ($ret['cmd']=='P' || $ret['cmd']=='K') {
    $ret['rtype']=UCS_RTYPE_PANIC;
  }
  if ($ret['rtype']===false) return false;
  return $ret;
}

function ucs_pad_r($str, $count, $symb=' ') {
  $str=(string)@$str; if (strlen($str)>$count) $str=substr($str, 0, $count); 
  return str_pad($str, $count, $symb, STR_PAD_RIGHT);
}

function ucs_pad_l($str, $count, $symb=' ') {
  $str=(string)@$str; if (strlen($str)>$count) $str=substr($str, 0, $count); 
  return str_pad($str, $count, $symb, STR_PAD_LEFT);
}

function ucs_encode_packet($pk) {
  if (!is_array($pk)) return false;
  $data='';
  if (@$pk['rtype']==UCS_RTYPE_REQUEST) {
    $data.='Q';
    $data.=ucs_pad_l(@$pk['ticket'], 64);
    $data.=ucs_pad_l(@$pk['addr'], 2);
    if (@$pk['dir']!=='I' && @$pk['dir']!=='O') return false;
    $data.=ucs_pad_l(@$pk['dir'], 1);
    $data.=ucs_pad_l(@$pk['date'], 19);
    return ucs_pad_r($data, 128, '!');
  } else if (@$pk['rtype']==UCS_RTYPE_RESPONSE) {
    $data.='Q';
    $data.=ucs_pad_l(@$pk['ticket'], 64);
    $data.=ucs_pad_l(@$pk['addr'], 2);
    if (@$pk['dir']!=='I' && @$pk['dir']!=='O') return false;
    $data.=ucs_pad_l(@$pk['dir'], 1);
    $data.=ucs_pad_l(@$pk['date'], 19);
    $data.=ucs_pad_l(@$pk['result'], 1);
    $data.=ucs_pad_r(@$pk['str1'], 20, '!');
    $data.=ucs_pad_r(@$pk['str2'], 20, '!');
    return ucs_pad_r($data, 128, '!');
  } else if (@$pk['rtype']==UCS_RTYPE_TRANSACTION) {
    $data.='T';
    $data.=ucs_pad_l(@$pk['ticket'], 64);
    $data.=ucs_pad_l(@$pk['addr'], 2);
    if (@$pk['dir']!=='I' && @$pk['dir']!=='O' && @$pk['dir']!==UCS_CANCEL_SYMBOL) return false;
    $data.=ucs_pad_l(@$pk['dir'], 1);
    $data.=ucs_pad_l(@$pk['date'], 19);
    return ucs_pad_r($data, 128, '!');
  } else if (@$pk['rtype']==UCS_RTYPE_ASYNC) {
    $data.='A';
    $data.=ucs_pad_l(@$pk['addr'], 2);
    if (@$pk['dir']!=='I' && @$pk['dir']!=='O') return false;
    $data.=ucs_pad_l(@$pk['dir'], 1);
    return ucs_pad_r($data, 128, '!');
  } else if (@$pk['rtype']==UCS_RTYPE_PANIC) {
    $data.='P';
    return ucs_pad_r($data, 128, '!');
  }  
  return false;
}
   
function ucs_on_recv(&$pool, $key, $buffer, &$readed=0, &$wait_len=0, &$seq_no=0) {
   global $dmn_main_conn, $glob;
      
   $offset=0;
   $prlog=!@$glob['llock'];
     
   if (strlen($buffer)<128) {
     $wait_len=128-strlen($buffer);
     return false;
   }  
   
   $buf=substr($buffer, 0, 128);
   $pk=ucs_decode_packet($buf);
   if ($pk===false) {
     plogs("ucs packet decode error. halting.\n");
     $pool->drop_connection($key, 'ucs packet decode error. stream broken.');
     return false;
   }
   if (!is_array($pk)) return $pk;

   $readed=128;

   if ($prlog) logp($glob['log_file'].'.p',
                    "received [".$key.':'.$seq_no."]:\n".   
                    $pool->dump_packet($buf).
                    "\n\nData:\n".
                    var_export($pk, true)."\n", 
                    true);

   return $pk;
}

function ucs_on_send(&$pool, $key, $data, $seq_no) {
  global $dmn_main_conn, $glob;

    $prlog=!@$glob['llock'];
    $buf=ucs_encode_packet($data);
      
    if ($prlog) logp($glob['log_file'].'.p',
                     "sended [".$key.':'.$seq_no."]:\n".   
                     $pool->dump_packet($buf).
                     "\n\nData:\n".
                     var_export($data, true)."\n", 
                     true);
//   plogs("sended:\n".var_export($data, true));
    return $buf;
}

function ucs_on_data(&$pool, $key) {
  global $dmn_main_conn, $glob;
//function on_data(&$pool, $key, $data, $seq_no) {
   global $glob;
   
   $data=$pool->get_data($key);
   if ($data===false) return false;
   $raw_data=$data[2];
   $seq_no=$data[1];
   $data=$data[0];
//   plogs("raw_data:\n".var_export($raw_data, true));
//   logp($glob['log_file'], "answer [".$key."]:\n".var_export($data[2], true)."\n", true);

   if (!@$data['rtype']) return true;
   if ($data['rtype']==UCS_RTYPE_ASYNC) {
     $cset=&conn_get_settings_by_id(@$data['addr']);
     if (@$cset['key']) {
      $dmn_main_conn['pool']->send($cset['key'], eproto_packet(eproto_cmd_RelayControlEx, pocket_rt_code($cset['apkey']), relay_on_ex(0x1FFFFFFF)));
//       $dmn_main_conn['pool']->send($cset['key'], eproto_RelayControl_packet(0, 0));
     }
   } else if ($data['rtype']==UCS_RTYPE_RESPONSE) {
     $skey=ucs_get_session_key_by_id(@$data['addr']);
     if ($skey) {
       if (!($sobj=&session_obj_get($skey))) return true;
       session_set_kpo_result($sobj, (@$data['result']=='Y' || (int)@$data['result']>0)?KPO_RES_YES:KPO_RES_NO, $data['str1'].$data['str2'], array('kpo_answer_data'=>$data));
       $ticket=trim(@$data['ticket']);
       if (strlen($ticket)>0 && $sobj['data']['kpo']['result']==KPO_RES_YES) {
//         $sobj['uid']=$ticket;
         $sobj['cid']=$ticket;
         if (@$glob['cam_service_active'] && !@$sobj['data']['cam']['result']) {
           session_cam_start_process($pool, $sobj['key'], session_get_tid($sobj['uid']), $sobj['uid'], $ticket, $sobj['id']);
         }
       } else session_clear_cam_data($sobj);
       
       session_check_done($sobj);
       return true;
     }
   }
   return true;
}

function ucs_idle_proc(&$pool, $mtf) {
  global $dmn_main_conn, $glob;
    
  
}
   

} // end incl_h
?>
