<?php
if (!defined("INC_USART_INL_H")){
   define("INC_USART_INL_H", TRUE);

   
function usart_rtag_pk($uid, $code=1) {
  $pk=eproto_packet(eproto_cmd_ReadTagExtended);
  $pk['code']=$code;
  $pk['payload']='';
  $pk['payload'].=numcoder_encode_r(strlen($uid), 1).$uid; // uid_len + uid
  $dblzero=numcoder_encode_r(0x0000, 2);
  $pk['payload'].=$dblzero; // finger result
  $pk['payload'].=$dblzero.$dblzero; // locker #1
  $pk['payload'].=$dblzero.$dblzero; // locker #2
  $pk['payload_hex']='';
  return $pk;
}

function usart_action($key, $data) {
  global $dmn_main_conn, $glob;
  $skey=session_create($data, $key);
  $glob[GLOB_KEY_SESSIONS][$skey]['data']['rfid']=$data;
  $glob[GLOB_KEY_SESSIONS][$skey]['is_barcode']=true;
//  $glob[GLOB_KEY_SESSIONS][$skey]['uid']='Q'.$glob[GLOB_KEY_SESSIONS][$skey]['uid'];
//  plogs("barcode session[".$key."]:\n".var_export(array(@$data, $glob[GLOB_KEY_SESSIONS][$skey]), true));

  $pk=eproto_packet(eproto_cmd_Interactive);
  $pk['payload']=pocket_interactive_waiting(7000, true, false);
  $dmn_main_conn['pool']->send($key, $pk);

  $id=$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['id'];

  if (@$glob['txp_subscriber_key']!==false) {
    session_set_kpo_result($glob[GLOB_KEY_SESSIONS][$skey], KPO_RES_UNDEF);
    $dir=(@$glob[GLOB_KEY_CONNECTIONS][$key]['settings']['role']=='checkout')?'O':'I';
    txp_send($glob['txp_subscriber_key'], 'SESSION_START', $id, 'Q'.$glob[GLOB_KEY_SESSIONS][$skey]['uid']);
    $glob[GLOB_KEY_SESSIONS][$skey]['req_time']=get_mtf();
    session_check_done($skey);
  } else if (@$glob['local_request_processing']) {
    session_set_kpo_result($glob[GLOB_KEY_SESSIONS][$skey], KPO_RES_NO, from_utf8("Ошибка\nсвязи.\n\nОбратитесь на\nрецепцию."), array('kpo_answer_data'=>'Link error'));
    if (@$glob['cam_service_active'] && !@$glob['cam_service_resolve_uid']) {
      session_cam_start_process($dmn_main_conn['pool'], $key, session_get_tid($skey), $data, $data, $skey);
    }
    session_check_done($skey);
  } else if ($glob['http_service_active']) {
    session_set_kpo_result($glob[GLOB_KEY_SESSIONS][$skey], KPO_RES_UNDEF);

    if (!handler_exec('hcfg_http', false, $http_cfg)) return true;
    if (!handler_exec('hurl_http', array(REQ_TAG_QRY, &$sobj, &$conn, &$http_cfg, $aparams), $hurl)) return true;
    if (!httpr_new($dmn_main_conn['pool'], $key, REQ_TAG_QRY, $http_cfg, $hurl, array($key, $ticket, 0x00))) {
      plogs("http request fail. link down.\n");
    }    
  }       

  session_check_done($skey);
//  $pk=eproto_packet(eproto_cmd_FingerRaw);$pk['payload']=chr(0x07);$dmn_main_conn['pool']->send($key, $pk);
//  $pk=eproto_packet(eproto_cmd_Beep);$dmn_main_conn['pool']->send($key, $pk);
//  ga($key, 1, from_utf8('Проходите'), $data, gat_resp(0x00));
}

function usart_parse_data($key, $data) {
  global $dmn_main_conn, $glob;
  $glob[GLOB_KEY_CONNECTIONS][$key]['lp']=&tlogs_add($glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], array('tkey'=>$glob[GLOB_KEY_CONNECTIONS][$key]['con_key'], 'type'=>'BARCODE_READ', 'time'=>get_mtf(), 'uid'=>$data));
  plogs("barcode data[".$key."]:\n".var_export($data, true)."\n");
  if (!is_string($data) || strlen($data)<4 || $data{0}!=']') {
    ga($key, 0, from_utf8("Ошибка\nчтения\nштрих-кода"), $data, gat_resp(0x00));
    return false;
  }
  $type=$data{1};
  $subtype=$data{2};
//  $int_data=str_pad(substr($data, 3), 14, '0', STR_PAD_LEFT);
  $int_data=substr($data, 3);
//  if ($int_data%2!=0) $int_data.='0';
//  $data=hexutil_hex2buf($int_data);
//  $data=($data>0)?numcoder_encode($data, 4):'';
  plogs("barcode int data[".$key."]:\n".var_export($int_data, true)."\n");
  if (strlen($data)<4 || strlen($data)>32) {
    ga($key, 0, from_utf8("\nНекорректный\nкод\n"), $data, gat_resp(0x00));
    return false;
  }
  usart_action($key, $int_data);
  return true;
}

function usart_parse_stream($key) {
  global $dmn_main_conn, $glob;
  $buf=$glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'];
  $offset=0;
  if (eproto_skip2marker($buf, $offset)) {
    $ret=eproto_packet_decode($buf, $offset, $pk);
    if (@$pk['cmd']) pocket_parse_packet($pk);
    
  }
  
  
  
  $start=strpos($buf, chr(0x02));
  if ($start===false) return;
  $end=strpos($buf, chr(0x03).chr(0x04), $start+1);
  if ($end===false) return;
  $data=substr($buf, $start+1, $end-$start-1);
  $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf']=substr($buf, $end+1);
  if (strlen($data)>0) usart_parse_data($key, $data);
}

function usart_process_stream($key, $data) {
   global $glob;
   $glob[GLOB_KEY_CONNECTIONS][$key]['vars']['usart_buf'].=$data;
   usart_parse_stream($key);
}

} // end incl_h
?>
