<?php
if (!defined("INC_UTIL_INL_H")){
  define("INC_UTIL_INL_H", TRUE);
  
define('REQ_TAG_TLIST', 0x00);
define('REQ_TAG_QRY', 0x01);
define('REQ_TAG_REG', 0x02);
define('REQ_TAG_CAM', 0x03);
define('REQ_TAG_ID', 0x04);
define('REQ_TAG_CRT', 0x05);

define('CAM_RES_UNDEF', 0x00);
define('CAM_RES_YES', 0x01);
define('CAM_RES_NO', 0x02);
define('CAM_RES_FAIL', 0x03);
define('CAM_RES_NF', 0x04);

define('KPO_RES_UNDEF', 0x00);
define('KPO_RES_YES', 0x01);
define('KPO_RES_NO', 0x02);
define('KPO_RES_FAIL', 0x03);

function cam_result_str($code) {
  if ($code===CAM_RES_UNDEF) return 'CAM_RES_UNDEF';
  if ($code===CAM_RES_YES) return 'CAM_RES_YES';
  if ($code===CAM_RES_NO) return 'CAM_RES_NO';
  if ($code===CAM_RES_FAIL) return 'CAM_RES_FAIL';
  if ($code===CAM_RES_NF) return 'CAM_RES_NF';
  return '';
}

function kpo_result_str($code) {
  if ($code===KPO_RES_UNDEF) return 'KPO_RES_UNDEF';
  if ($code===KPO_RES_YES) return 'KPO_RES_YES';
  if ($code===KPO_RES_NO) return 'KPO_RES_NO';
  if ($code===KPO_RES_FAIL) return 'KPO_RES_FAIL';
  return '';
}

function av($array, $key) {
  if (!is_array($array) || !array_key_exists($key, $array)) return null;
  return $array[$key];
}

function get_nl() {
  global $glob;
  return (array_key_exists('log_nl', $glob))?$glob['log_nl']:LOG_NL;
}

function agov(&$arr, $keys, $nfval=false) {
  if (!is_array($arr) || count($arr)==0) return $nfval;
  if (is_string($keys)) $keys=array($keys);
  if (!is_array($keys) || count($keys)==0) return $nfval;
  foreach ($keys as $key) if ((is_string($key) || is_int($key)) && array_key_exists($key, $arr)) return $arr[$key];
  return $nfval;
}

function set_int(&$var, $val, $min=false, $max=false) {
  $val=(int)$val;
  if (is_integer($min) && $val<(int)$min) return false;
  if (is_integer($max) && $val>(int)$max) return false;
  $var=$val;
  return true;
}

function set_float(&$var, $val, $min=false, $max=false) {
  $val=(float)$val;
  if ((is_integer($min) || is_float($min)) && $val<(float)$min) return false;
  if ((is_integer($max) || is_float($max)) && $val>(float)$max) return false;
  $var=$val;
  return true;
}

function set_bool(&$var, $val) {
  $var=(bool)$val;
  return true;
}
  
function plog($str) {
//  $md=log_micro_date("[d-m-y H:i:s.u] ");
  $md=date("[d-m-y H:i:s] ");
  $str=$md.$str;
  $str=preg_replace('/\r/', '', $str);
  $a=explode("\n", $str);
  $l=count($a);
  $md=str_repeat(' ', 20);

  if ($l>1) for($i=0;$i<$l;$i++) {
    $s=(string)$a[$i];
    if ($i>0 && ($i<$l-1 || $s!='')) {
      $s=$md.$s;
      $a[$i]=$s;
    }
  }
  return implode(NL, $a);
}

function logp($fname, $str, $param=false) {
   global $dmn_main_conn;
   if (!is_string($fname)) return false;
   return log_print($dmn_main_conn['daemon']->log_subdir().$fname, fix_nl($str), $param, false, NL);
}

function plogs($str, $add=false) {
  global $glob, $dmn_main_conn;

  if ($add!==false) {
    if ($add===true) $add="\n";
    $str.=$add;
  }
  
  $str=fix_nl(plog($str));
  if (IS_WIN) print($str);
  if (@$glob['log_file_screen']) return log_print($dmn_main_conn['daemon']->log_subdir().$glob['log_file_screen'], $str, false, true, "");
}
  
function uid2hex($uid) {
  return strtoupper(hexutil_buf2hex($uid));
}

function gen_id() {
   global $glob;
   return $glob['id_gen']++;
   return 'auto_id_'.($glob['id_gen']++);
}
  
function gec($is_common=false) {
  global $glob;
  $k=($is_common)?'log_event_count':'log_dev_event_count';
  $c=(int)$glob[$k];
  if ($c<0) $c=0;
  if ($c>5000) $c=5000;
  return $c;
}

function var_d($var, $dumb=true) {
  return fix_nl(var_export($var, true));
}

function fix_nl($str) {
  $str=preg_replace('/\r/', '', $str);
  if (NL!="\n") $str=preg_replace('/\n/', NL, $str);
  return $str;
}

function nds($d, $s=' ', $p='0x') {
   $res=array();
   $l=strlen($d);
   $ind=-1;
   $fmt=$p.'%02X';
   while (++$ind<$l) array_push($res, sprintf($fmt,ord($d{$ind})));
   return implode($s, $res);
}

function extract_cid($data) {
  return trim($data);
}

function send_slave_USART_packet($key, $cmd, $flags=0, $data=false) {
  global $dmn_main_conn, $glob;
//  $pks=eproto_packet($cmd, $flags, $data);
//  pocket_parse_packet($data);
  $pk=eproto_packet(eproto_cmd_USARTRaw, 0, eproto_packet_encode(eproto_packet($cmd, $flags, $data)));
  $dmn_main_conn['pool']->send($key, $pk);
}
  
function get_dst($time) {
   $tbuf = localtime($time, true);
   if ($tbuf['tm_isdst']) return 3600;
   return 0;
}

function correct_unix_time($time) {
   return $time-get_dst($time);
}

function correct_unix_time_r($time) {
   return $time+get_dst($time);
}

function day_to_unix_time($day) {
   $t=$day*86400;
   $t=correct_unix_time($t);
   return $t;
}

function day_from_unix_time($uts) {
   $d=(int)(correct_unix_time_r($uts)/86400);
   return (int)($uts/86400);
}

function nl2comma($str) {
  $str=preg_replace('/\r/', '', (string)$str);
  $str=preg_replace('/\n/', ';', $str);
  return $str;
}

function colon2nl($s) {
  global $phrases_fixes;
  if (array_key_exists($s, $phrases_fixes)) $s=@$phrases_fixes[@$s];
  return preg_replace('/\;/', NL, $s);
}

function parse_gmc($c) {
  $c=strtoupper(trim($c));
  if (preg_match('/^[\da-fA-F]{8,20}$/', $c)) return $c;
  return false;
}

function &aarr(&$arr, $key) {
  if (!array_key_exists($key, $arr) || !is_array($arr[$key])) $arr[$key]=array();
  return $arr[$key];
}

function &larr($key=false) {
  global $term_logs;
  if ($key===false) return aarr($term_logs, 'common');
  aarr($term_logs, 'dev');
  return aarr($term_logs['dev'], $key);
}

function &garr($key, $u=false, $wr=false) {
  global $glob;
  $r=&aarr($glob, $key);
  if ($u!==false) {
    if (array_key_exists($u, $r)) {
      return $r[$u];
    } else {
      return $wr;
    }
  }
  return $r;
}

function &tlogs_add($id, $arr=false) {
  if ($arr===false) return false;

  $clog=&larr();
  $c=gec(true)-1;while (count($clog)>$c) array_shift($clog);
  $clog[]=&$arr;
//  array_push($clog, &$arr);
//  $rv=&$clog[count($clog)-1];

  if ($id) {
    $dlog=&larr($id);
    $c=gec(false)-1;while (count($dlog)>$c) array_shift($dlog);
    $dlog[]=&$arr;
//    array_push($dlog, &$arr);
  }
  return $arr;
}

function is_ip(&$ip) {
  $re='/^([\d]{1,3})\.([\d]{1,3})\.([\d]{1,3})\.([\d]{1,3})$/';
  if (!preg_match($re, trim($ip), $m)) return false;
  $r=array();
  for ($i=1;$i<5;$i++) {
    $b=(int)$m[$i];
    if ($b>255) return false;
    $r[]=$b;
  }
  $ip=implode('.', $r);
  return true;
}

function to_utf8($array) {
  if (is_string($array)) return @iconv("windows-1251", "UTF-8", $array);
  if (!is_array($array)) return $array;
  foreach (array_keys($array) as $key) {
    $array[$key]=to_utf8($array[$key]);
  }
  return $array;
}

function from_utf8($array) {
  if (is_string($array)) return @iconv("UTF-8", "windows-1251", $array);
  if (!is_array($array)) return $array;
  foreach (array_keys($array) as $key) {
    $array[$key]=from_utf8($array[$key]);
  }
  return $array;
}

function cp866($str) {
//   global $glob;
//   logp($glob['log_file'], "cp866 [".$str."]\n");
//  return $str;
  if (!IS_WIN) return $str;
  return iconv('CP1251', 'CP866', $str);
}

function get_mta() {
  $mta=explode(" ", microtime());
  $mta[0]=(float)$mta[0];
  $mta[1]=(float)$mta[1];
  return $mta;
}

function get_mtf() {
  $mta=get_mta();
  return ((float)$mta[1] + (float)$mta[0]);
}

function cut_bom($str) {
  if (substr($str, 0,3) == pack("CCC",0xef,0xbb,0xbf)) { $str = substr($str, 3); }
  return $str;
}

function jsondec($str) {
  $ret=from_utf8(json_decode(cut_bom($str), true));
  return $ret;
}

function jsonenc($data) {
  $ret=json_encode(to_utf8($data));
  return $ret;
}

function w2d($array, $force=false) {
  if (is_string($array)) return (IS_WIN || $force)?@iconv('CP1251', 'CP866', $array):$array;
  if (!is_array($array)) return $array;
  foreach (array_keys($array) as $key) {
    $array[$key]=w2d($array[$key]);
  }
  return $array;
}

function json_as_rows($array) {
  global $glob;
//  if ($glob['http_service_active']) {
    return json_as_rows_srv($array);
//  } else {
//    return json_as_rows_db($array);
//  }
}

function json_as_rows_srv($array) {
  if (!is_array($array)) return $array;
  $array=array_change_key_case($array, CASE_UPPER);
  foreach (array_keys($array) as $key) {
    $array[$key]=json_as_rows($array[$key]);
  }
  return $array;
}

function __json_as_rows__($json) {
  if (!is_array($json)) return false;
  foreach ($json as &$rarr) {
    if (!is_array($rarr)) return false;
    $rarr=array_change_key_case($rarr, CASE_UPPER);
  }
  return $json;
}

function json_as_rows_db($json) {
  if (!is_array(@$json['columns'])) return false;
  $fcount=count($json['columns']);
  if (!is_array(@$json['rows'])) return false;
  $ret=array();
  foreach ($json['rows'] as $rarr) {
    if (!is_array($rarr) || count($rarr)!=$fcount) return false;
    $row=array();
    for ($i=0;$i<$fcount;$i++) {
      $fname=strtoupper(trim(@$json['columns'][$i]['name']));
      if ($fname=='') return false;
      $row[$fname]=@$rarr[$i]['value'];
    }
    $ret[]=$row;
  }
  return $ret;
}

function json_as_row($json) {
  $rows=json_as_rows($json);
  if (!is_array($rows) || count($rows)==0) return false;
  return array_shift($rows);
}


  
} // end incl_h
?>
